/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.featurestore.support;

import java.util.HashMap;
import java.util.Map;
import org.calrissian.accumulorecipes.featurestore.model.Feature;
import org.calrissian.accumulorecipes.featurestore.support.config.AccumuloFeatureConfig;
import org.calrissian.accumulorecipes.featurestore.support.config.MetricFeatureConfig;

public class FeatureRegistry {
    public static final FeatureRegistry BASE_FEATURES = new FeatureRegistry(new MetricFeatureConfig());
    private Map<Class, AccumuloFeatureConfig> classToTransform = new HashMap<Class, AccumuloFeatureConfig>();

    public FeatureRegistry(AccumuloFeatureConfig ... transforms) {
        for (AccumuloFeatureConfig featureTransform : transforms) {
            this.classToTransform.put(featureTransform.transforms(), featureTransform);
        }
    }

    public AccumuloFeatureConfig transformForClass(Class<? extends Feature> clazz) {
        return this.classToTransform.get(clazz);
    }

    public Iterable<AccumuloFeatureConfig> getConfigs() {
        return this.classToTransform.values();
    }
}

