/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.featurestore.support.config;

import com.google.common.base.Function;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.Value;
import org.apache.commons.lang.StringUtils;
import org.calrissian.accumulorecipes.commons.support.TimeUnit;
import org.calrissian.accumulorecipes.featurestore.model.Metric;
import org.calrissian.accumulorecipes.featurestore.model.MetricFeature;
import org.calrissian.accumulorecipes.featurestore.support.StatsCombiner;
import org.calrissian.accumulorecipes.featurestore.support.Utilities;
import org.calrissian.accumulorecipes.featurestore.support.config.AccumuloFeatureConfig;

public class MetricFeatureConfig
implements AccumuloFeatureConfig<MetricFeature> {
    public static final Function<Value, Metric> valueToVector = new Function<Value, Metric>(){

        public Metric apply(Value value) {
            String[] vals = StringUtils.splitPreserveAllTokens((String)new String(value.get()), (String)",");
            return new Metric(Long.parseLong(vals[0]), Long.parseLong(vals[1]), Long.parseLong(vals[2]), Long.parseLong(vals[3]), new BigInteger(vals[4]));
        }
    };
    public static final Function<Metric, Value> vectorToValue = new Function<Metric, Value>(){

        public Value apply(Metric metricFeatureVector) {
            return new Value(StringUtils.join(Arrays.asList(metricFeatureVector.getMin(), metricFeatureVector.getMax(), metricFeatureVector.getSum(), metricFeatureVector.getCount(), metricFeatureVector.getSumSquare().toString()), (String)",").getBytes());
        }
    };

    @Override
    public Class<MetricFeature> transforms() {
        return MetricFeature.class;
    }

    @Override
    public Value buildValue(MetricFeature feature) {
        return (Value)vectorToValue.apply(feature.getVector());
    }

    @Override
    public MetricFeature buildFeatureFromValue(long timestamp, String group, String type, String name, String visibility, Value value) {
        Metric metricFeatureVector = (Metric)valueToVector.apply((Object)value);
        return new MetricFeature(timestamp, group, type, name, visibility, metricFeatureVector);
    }

    @Override
    public String featureName() {
        return "metric";
    }

    @Override
    public List<IteratorSetting> buildIterators(int priority) {
        ArrayList<IteratorSetting.Column> columns = new ArrayList<IteratorSetting.Column>();
        for (TimeUnit timeUnit : TimeUnit.values()) {
            columns.add(new IteratorSetting.Column(Utilities.combine(this.featureName(), timeUnit.toString())));
        }
        IteratorSetting setting = new IteratorSetting(priority, "stats", StatsCombiner.class);
        StatsCombiner.setColumns((IteratorSetting)setting, columns);
        return Collections.singletonList(setting);
    }
}

