/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.featurestore.hadoop;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.mapreduce.InputFormatBase;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.user.RegExFilter;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.format.DefaultFormatter;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.calrissian.accumulorecipes.commons.support.TimeUnit;
import org.calrissian.accumulorecipes.commons.support.TimestampUtil;
import org.calrissian.accumulorecipes.featurestore.model.Feature;
import org.calrissian.accumulorecipes.featurestore.support.FeatureRegistry;
import org.calrissian.accumulorecipes.featurestore.support.FeatureTransform;
import org.calrissian.accumulorecipes.featurestore.support.Utilities;
import org.calrissian.accumulorecipes.featurestore.support.config.AccumuloFeatureConfig;
import org.calrissian.mango.io.Serializables;

public class FeaturesInputFormat
extends InputFormatBase<Key, Feature> {
    public static void setInputInfo(Job job, String username, byte[] password, Authorizations auths) throws AccumuloSecurityException {
        FeaturesInputFormat.setConnectorInfo((Job)job, (String)username, (AuthenticationToken)new PasswordToken(password));
        FeaturesInputFormat.setInputTableName((Job)job, (String)"features");
        FeaturesInputFormat.setScanAuthorizations((Job)job, (Authorizations)auths);
    }

    public static void setQueryInfo(Job job, Date start, Date end, TimeUnit timeUnit, String group, String type, String name, Class<? extends Feature> featureType) throws IOException {
        FeaturesInputFormat.setQueryInfo(job, start, end, timeUnit, group, type, name, featureType, FeatureRegistry.BASE_FEATURES);
    }

    public static void setQueryInfo(Job job, Date start, Date end, TimeUnit timeUnit, String group, String type, String name, Class<? extends Feature> featureType, FeatureRegistry registry) throws IOException {
        AccumuloFeatureConfig featureConfig = registry.transformForClass(featureType);
        job.getConfiguration().set("featureConfig", new String(Serializables.toBase64((Serializable)featureConfig)));
        job.getConfiguration().set("timeUnit", timeUnit.toString());
        FeaturesInputFormat.setRanges((Job)job, Collections.singleton(new Range((CharSequence)Utilities.combine(group, TimestampUtil.generateTimestamp((long)end.getTime(), (TimeUnit)timeUnit)), (CharSequence)Utilities.combine(group, TimestampUtil.generateTimestamp((long)start.getTime(), (TimeUnit)timeUnit)))));
        if (name != null) {
            Pair column = new Pair((Object)new Text(Utilities.combine(timeUnit.toString(), featureConfig.featureName())), (Object)new Text(Utilities.combine(type, name)));
            FeaturesInputFormat.fetchColumns((Job)job, Collections.singleton(column));
        } else {
            Pair column = new Pair((Object)new Text(Utilities.combine(timeUnit.toString(), featureConfig.featureName())), null);
            FeaturesInputFormat.fetchColumns((Job)job, Collections.singleton(column));
            if (type != null) {
                String cqRegex = null;
                cqRegex = Utilities.combine(type, "(.*)");
                IteratorSetting regexIterator = new IteratorSetting(14, "regex", RegExFilter.class);
                RegExFilter.setRegexs((IteratorSetting)regexIterator, null, null, (String)cqRegex, null, (boolean)false);
                FeaturesInputFormat.addIterator((Job)job, (IteratorSetting)regexIterator);
            }
        }
    }

    public RecordReader<Key, Feature> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        try {
            final AccumuloFeatureConfig config = (AccumuloFeatureConfig)Serializables.fromBase64((byte[])context.getConfiguration().get("featureConfig").getBytes());
            final FeatureTransform<Feature> entryTransform = new FeatureTransform<Feature>(){

                @Override
                protected Feature transform(long timestamp, String group, String type, String name, String visibility, Value value) {
                    return (Feature)config.buildFeatureFromValue(timestamp, type, group, name, visibility, value);
                }
            };
            return new InputFormatBase.RecordReaderBase<Key, Feature>(){

                public boolean nextKeyValue() throws IOException, InterruptedException {
                    if (this.scannerIterator.hasNext()) {
                        ++this.numKeysRead;
                        Map.Entry entry = (Map.Entry)this.scannerIterator.next();
                        this.currentKey = (Key)entry.getKey();
                        this.currentK = this.currentKey;
                        this.currentV = entryTransform.apply(entry);
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Processing key/value pair: " + DefaultFormatter.formatEntry((Map.Entry)entry, (boolean)true)));
                        }
                        return true;
                    }
                    return false;
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

