/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.graphstore.tinkerpop.query;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Query;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.VertexQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.calrissian.accumulorecipes.commons.domain.Auths;
import org.calrissian.accumulorecipes.graphstore.GraphStore;
import org.calrissian.accumulorecipes.graphstore.model.Direction;
import org.calrissian.accumulorecipes.graphstore.tinkerpop.EntityGraph;
import org.calrissian.accumulorecipes.graphstore.tinkerpop.model.EntityVertex;
import org.calrissian.mango.collect.CloseableIterable;
import org.calrissian.mango.collect.CloseableIterables;
import org.calrissian.mango.criteria.builder.QueryBuilder;
import org.calrissian.mango.criteria.domain.Node;
import org.calrissian.mango.domain.entity.EntityIndex;

public class EntityVertexQuery
implements VertexQuery {
    private GraphStore graphStore;
    private EntityVertex vertex;
    private Auths auths;
    private com.tinkerpop.blueprints.Direction direction = com.tinkerpop.blueprints.Direction.BOTH;
    private String[] labels = null;
    private int limit = -1;
    private QueryBuilder queryBuilder = new QueryBuilder().and();

    public EntityVertexQuery(EntityVertex vertex, GraphStore graphStore, Auths auths) {
        this.vertex = vertex;
        this.graphStore = graphStore;
        this.auths = auths;
    }

    public VertexQuery direction(com.tinkerpop.blueprints.Direction direction) {
        this.direction = direction;
        return this;
    }

    public VertexQuery labels(String ... labels) {
        this.labels = labels;
        return this;
    }

    public long count() {
        CloseableIterable<Edge> edges = this.edges();
        long count = Iterables.size(edges);
        edges.closeQuietly();
        return count;
    }

    public CloseableIterable<EntityIndex> vertexIds() {
        return CloseableIterables.transform(this.vertices(), (Function)new EntityGraph.EntityIndexXform());
    }

    public VertexQuery has(String key) {
        this.queryBuilder = this.queryBuilder.has(key);
        return this;
    }

    public VertexQuery hasNot(String key) {
        this.queryBuilder = this.queryBuilder.hasNot(key);
        return this;
    }

    public VertexQuery has(String key, Object value) {
        this.queryBuilder = this.queryBuilder.eq(key, value);
        return this;
    }

    public VertexQuery hasNot(String key, Object value) {
        this.queryBuilder = this.queryBuilder.notEq(key, value);
        return this;
    }

    public VertexQuery has(String key, Predicate predicate, Object value) {
        if (predicate.toString().equals("EQUAL")) {
            return this.has(key, value);
        }
        if (predicate.toString().equals("NOT_EQUAL")) {
            return this.hasNot(key, value);
        }
        if (predicate.toString().equals("GREATER_THAN")) {
            this.queryBuilder = this.queryBuilder.greaterThan(key, value);
        } else if (predicate.toString().equals("LESS_THAN")) {
            this.queryBuilder = this.queryBuilder.lessThan(key, value);
        } else if (predicate.toString().equals("GREATER_THAN_EQUAL")) {
            this.queryBuilder = this.queryBuilder.greaterThanEq(key, value);
        } else if (predicate.toString().equals("LESS_THAN_EQUAL")) {
            this.queryBuilder = this.queryBuilder.lessThanEq(key, value);
        } else if (predicate.toString().equals("IN")) {
            this.queryBuilder = this.queryBuilder.in(key, (Collection)value);
        } else if (predicate.toString().equals("NOT_IN")) {
            this.queryBuilder = this.queryBuilder.notIn(key, (Collection)value);
        } else {
            throw new UnsupportedOperationException("Predicate with type " + predicate + " is not supported.");
        }
        return this;
    }

    public <T extends Comparable<T>> VertexQuery has(String key, T value, Query.Compare compare) {
        return this.has(key, (Predicate)compare, value);
    }

    public <T extends Comparable<?>> VertexQuery interval(String key, T start, T stop) {
        this.queryBuilder = this.queryBuilder.range(key, start, stop);
        return this;
    }

    public VertexQuery limit(int limit) {
        this.limit = limit;
        return this;
    }

    public CloseableIterable<Edge> edges() {
        Node query = this.queryBuilder.end().build();
        List<EntityIndex> vertexIndex = Collections.singletonList(new EntityIndex(this.vertex.getEntity().getType(), this.vertex.getEntity().getId()));
        ArrayList<Direction> dirs = new ArrayList<Direction>();
        if (this.direction == com.tinkerpop.blueprints.Direction.IN || this.direction == com.tinkerpop.blueprints.Direction.BOTH) {
            dirs.add(Direction.IN);
        }
        if (this.direction == com.tinkerpop.blueprints.Direction.OUT || this.direction == com.tinkerpop.blueprints.Direction.BOTH) {
            dirs.add(Direction.OUT);
        }
        CloseableIterable edges = null;
        for (Direction dir : dirs) {
            CloseableIterable entityEdges;
            CloseableIterable closeableIterable = this.labels == null ? this.graphStore.adjacentEdges(vertexIndex, (Node)(query.children().size() > 0 ? query : null), dir, this.auths) : (entityEdges = this.graphStore.adjacentEdges(vertexIndex, (Node)(query.children().size() > 0 ? query : null), dir, Sets.newHashSet((Object[])this.labels), this.auths));
            if (edges == null) {
                edges = entityEdges;
                continue;
            }
            edges = CloseableIterables.chain((CloseableIterable[])new CloseableIterable[]{edges, entityEdges});
        }
        CloseableIterable finalEdges = CloseableIterables.transform(edges, (Function)new EntityGraph.EdgeEntityXform(this.graphStore, this.auths));
        if (this.limit > -1) {
            return CloseableIterables.limit((CloseableIterable)finalEdges, (int)this.limit);
        }
        return finalEdges;
    }

    public CloseableIterable<Vertex> vertices() {
        Node query = this.queryBuilder.end().build();
        List<EntityIndex> vertexIndex = Collections.singletonList(new EntityIndex(this.vertex.getEntity().getType(), this.vertex.getEntity().getId()));
        ArrayList<Direction> dirs = new ArrayList<Direction>();
        if (this.direction == com.tinkerpop.blueprints.Direction.IN || this.direction == com.tinkerpop.blueprints.Direction.BOTH) {
            dirs.add(Direction.IN);
        }
        if (this.direction == com.tinkerpop.blueprints.Direction.OUT || this.direction == com.tinkerpop.blueprints.Direction.BOTH) {
            dirs.add(Direction.OUT);
        }
        CloseableIterable vertices = null;
        for (Direction dir : dirs) {
            CloseableIterable entityvertices;
            CloseableIterable closeableIterable = this.labels == null ? this.graphStore.adjacencies(vertexIndex, (Node)(query.children().size() > 0 ? query : null), dir, this.auths) : (entityvertices = this.graphStore.adjacencies(vertexIndex, (Node)(query.children().size() > 0 ? query : null), dir, Sets.newHashSet((Object[])this.labels), this.auths));
            if (vertices == null) {
                vertices = entityvertices;
                continue;
            }
            vertices = CloseableIterables.chain((CloseableIterable[])new CloseableIterable[]{vertices, entityvertices});
        }
        CloseableIterable finalVertices = CloseableIterables.transform(vertices, (Function)new EntityGraph.VertexEntityXform(this.graphStore, this.auths));
        if (this.limit > -1) {
            return CloseableIterables.limit((CloseableIterable)finalVertices, (int)this.limit);
        }
        return finalVertices;
    }
}

