/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.graphstore.impl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.io.Text;
import org.calrissian.accumulorecipes.commons.domain.Auths;
import org.calrissian.accumulorecipes.commons.domain.StoreConfig;
import org.calrissian.accumulorecipes.commons.support.Constants;
import org.calrissian.accumulorecipes.commons.support.Scanners;
import org.calrissian.accumulorecipes.commons.support.tuple.Metadata;
import org.calrissian.accumulorecipes.entitystore.impl.AccumuloEntityStore;
import org.calrissian.accumulorecipes.entitystore.support.EntityShardBuilder;
import org.calrissian.accumulorecipes.graphstore.GraphStore;
import org.calrissian.accumulorecipes.graphstore.model.Direction;
import org.calrissian.accumulorecipes.graphstore.model.EdgeEntity;
import org.calrissian.accumulorecipes.graphstore.support.EdgeGroupingIterator;
import org.calrissian.accumulorecipes.graphstore.support.TupleStoreCriteriaPredicate;
import org.calrissian.accumulorecipes.graphstore.tinkerpop.EntityGraph;
import org.calrissian.mango.collect.CloseableIterable;
import org.calrissian.mango.collect.CloseableIterables;
import org.calrissian.mango.criteria.domain.Node;
import org.calrissian.mango.criteria.support.NodeUtils;
import org.calrissian.mango.domain.Tuple;
import org.calrissian.mango.domain.entity.BaseEntity;
import org.calrissian.mango.domain.entity.Entity;
import org.calrissian.mango.domain.entity.EntityIndex;
import org.calrissian.mango.domain.entity.EntityRelationship;
import org.calrissian.mango.types.LexiTypeEncoders;
import org.calrissian.mango.types.TypeRegistry;
import org.calrissian.mango.types.encoders.AliasConstants;

public class AccumuloEntityGraphStore
extends AccumuloEntityStore
implements GraphStore {
    public static final String DEFAULT_TABLE_NAME = "entityStore_graph";
    public static final int DEFAULT_BUFFER_SIZE = 50;
    private final int bufferSize;
    private final TypeRegistry<String> typeRegistry;
    private Function<Map.Entry<Key, Value>, Entity> edgeRowXform = new Function<Map.Entry<Key, Value>, Entity>(){

        public Entity apply(Map.Entry<Key, Value> keyValueEntry) {
            String cq = keyValueEntry.getKey().getColumnQualifier().toString();
            int idx = cq.indexOf("\u0000");
            String edge = cq.substring(0, idx);
            try {
                EntityRelationship edgeRel = (EntityRelationship)AccumuloEntityGraphStore.this.typeRegistry.decode(AliasConstants.ENTITY_RELATIONSHIP_ALIAS, (Object)edge);
                BaseEntity entity = new BaseEntity(edgeRel.getType(), edgeRel.getId());
                SortedMap<Key, Value> entries = EdgeGroupingIterator.decodeRow(keyValueEntry.getKey(), keyValueEntry.getValue());
                for (Map.Entry<Key, Value> entry : entries.entrySet()) {
                    if (entry.getKey().getColumnQualifier().toString().indexOf("\u0001") == -1) continue;
                    String[] qualParts = StringUtils.splitPreserveAllTokens((String)entry.getKey().getColumnQualifier().toString(), (String)"\u0001");
                    String[] keyALiasValue = StringUtils.splitPreserveAllTokens((String)qualParts[1], (String)"\u0000");
                    String vis = entry.getKey().getColumnVisibility().toString();
                    Tuple tuple = new Tuple(keyALiasValue[0], AccumuloEntityGraphStore.this.typeRegistry.decode(keyALiasValue[1], (Object)keyALiasValue[2]), Metadata.Visiblity.setVisibility(new HashMap(1), (String)vis));
                    entity.put(tuple);
                }
                return entity;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    };
    protected String table;
    protected BatchWriter writer;

    public AccumuloEntityGraphStore(Connector connector) throws TableExistsException, AccumuloSecurityException, AccumuloException, TableNotFoundException {
        super(connector);
        this.bufferSize = 50;
        this.table = DEFAULT_TABLE_NAME;
        this.typeRegistry = LexiTypeEncoders.LEXI_TYPES;
        this.init();
    }

    public AccumuloEntityGraphStore(Connector connector, String indexTable, String shardTable, String edgeTable, EntityShardBuilder shardBuilder, StoreConfig config, TypeRegistry<String> typeRegistry, int bufferSize) throws TableExistsException, AccumuloSecurityException, AccumuloException, TableNotFoundException {
        super(connector, indexTable, shardTable, shardBuilder, config, typeRegistry);
        this.bufferSize = bufferSize;
        this.table = edgeTable;
        this.typeRegistry = typeRegistry;
        this.init();
    }

    private void init() throws TableExistsException, AccumuloSecurityException, AccumuloException, TableNotFoundException {
        if (!this.getConnector().tableOperations().exists(this.table)) {
            this.getConnector().tableOperations().create(this.table);
        }
        this.writer = this.getConnector().createBatchWriter(this.table, this.getConfig().getMaxMemory(), this.getConfig().getMaxLatency(), this.getConfig().getMaxWriteThreads());
    }

    @Override
    public CloseableIterable<EdgeEntity> adjacentEdges(List<EntityIndex> fromVertices, Node query, Direction direction, Set<String> labels, Auths auths) {
        Preconditions.checkNotNull(labels);
        CloseableIterable<Entity> entities = this.findAdjacentEdges(fromVertices, query, direction, labels, auths);
        return CloseableIterables.transform(entities, (Function)new Function<Entity, EdgeEntity>(){

            public EdgeEntity apply(Entity entity) {
                return new EdgeEntity(entity);
            }
        });
    }

    @Override
    public CloseableIterable<EdgeEntity> adjacentEdges(List<EntityIndex> fromVertices, Node query, Direction direction, Auths auths) {
        CloseableIterable<Entity> entities = this.findAdjacentEdges(fromVertices, query, direction, null, auths);
        return CloseableIterables.transform(entities, (Function)new Function<Entity, EdgeEntity>(){

            public EdgeEntity apply(Entity entity) {
                return new EdgeEntity(entity);
            }
        });
    }

    @Override
    public CloseableIterable<Entity> adjacencies(List<EntityIndex> fromVertices, Node query, Direction direction, Set<String> labels, final Auths auths) {
        CloseableIterable<Entity> edges = this.findAdjacentEdges(fromVertices, query, direction, labels, auths);
        CloseableIterable indexes = CloseableIterables.transform(edges, (Function)new EntityGraph.EdgeToVertexIndexXform(direction));
        return CloseableIterables.concat((CloseableIterable)CloseableIterables.transform((CloseableIterable)CloseableIterables.partition((CloseableIterable)indexes, (int)this.bufferSize), (Function)new Function<List<EntityIndex>, Iterable<Entity>>(){

            public Iterable<Entity> apply(List<EntityIndex> entityIndexes) {
                LinkedList<Entity> entityCollection = new LinkedList<Entity>();
                CloseableIterable entities = AccumuloEntityGraphStore.this.get(entityIndexes, null, auths);
                Iterables.addAll(entityCollection, (Iterable)entities);
                entities.closeQuietly();
                return entityCollection;
            }
        }));
    }

    @Override
    public CloseableIterable<Entity> adjacencies(List<EntityIndex> fromVertices, Node query, Direction direction, Auths auths) {
        return this.adjacencies(fromVertices, query, direction, null, auths);
    }

    private CloseableIterable<Entity> findAdjacentEdges(List<EntityIndex> fromVertices, Node query, Direction direction, Set<String> labels, Auths auths) {
        Preconditions.checkNotNull(fromVertices);
        Preconditions.checkNotNull((Object)auths);
        TupleStoreCriteriaPredicate filter = query != null ? new TupleStoreCriteriaPredicate(NodeUtils.criteriaFromNode((Node)query)) : null;
        try {
            BatchScanner scanner = this.getConnector().createBatchScanner(this.table, auths.getAuths(), this.getConfig().getMaxQueryThreads());
            IteratorSetting setting = new IteratorSetting(15, EdgeGroupingIterator.class);
            scanner.addScanIterator(setting);
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (EntityIndex entity : fromVertices) {
                String row = (String)this.typeRegistry.encode((Object)new EntityRelationship(entity.getType(), entity.getId()));
                if (labels != null) {
                    for (String label : labels) {
                        this.populateRange(ranges, row, direction, label);
                    }
                    continue;
                }
                this.populateRange(ranges, row, direction, null);
            }
            scanner.setRanges(ranges);
            CloseableIterable entities = CloseableIterables.transform((CloseableIterable)Scanners.closeableIterable((ScannerBase)scanner), this.edgeRowXform);
            if (filter != null) {
                return CloseableIterables.filter((CloseableIterable)entities, (Predicate)filter);
            }
            return entities;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void populateRange(Collection<Range> ranges, String row, Direction direction, String label) {
        ranges.add(Range.prefix((CharSequence)row, (CharSequence)(direction.toString() + "\u0000" + StringUtils.defaultString((String)label))));
    }

    public void save(Iterable<? extends Entity> entities) {
        super.save(entities);
        for (Entity entity : entities) {
            if (!this.isEdge(entity)) continue;
            EntityRelationship edgeRelationship = new EntityRelationship(entity);
            EntityRelationship toVertex = (EntityRelationship)entity.get("tail").getValue();
            EntityRelationship fromVertex = (EntityRelationship)entity.get("head").getValue();
            String toVertexVis = Metadata.Visiblity.getVisibility((Tuple)entity.get("tail"), (String)"");
            String fromVertexVis = Metadata.Visiblity.getVisibility((Tuple)entity.get("head"), (String)"");
            String label = (String)entity.get("edgeLabel").getValue();
            try {
                String fromEncoded = (String)this.typeRegistry.encode((Object)fromVertex);
                String toEncoded = (String)this.typeRegistry.encode((Object)toVertex);
                String edgeEncoded = (String)this.typeRegistry.encode((Object)edgeRelationship);
                Mutation forward = new Mutation((CharSequence)fromEncoded);
                Mutation reverse = new Mutation((CharSequence)toEncoded);
                forward.put(new Text(Direction.OUT.toString() + "\u0000" + label), new Text(edgeEncoded + "\u0000" + toEncoded), new ColumnVisibility(toVertexVis), Constants.EMPTY_VALUE);
                reverse.put(new Text(Direction.IN.toString() + "\u0000" + label), new Text(edgeEncoded + "\u0000" + fromEncoded), new ColumnVisibility(fromVertexVis), Constants.EMPTY_VALUE);
                for (Tuple tuple : entity.getTuples()) {
                    String key = tuple.getKey();
                    String alias = this.typeRegistry.getAlias(tuple.getValue());
                    String value = (String)this.typeRegistry.encode(tuple.getValue());
                    String keyAliasValue = key + "\u0000" + alias + "\u0000" + value;
                    forward.put(new Text(Direction.OUT.toString() + "\u0000" + label), new Text(edgeEncoded + "\u0000" + toEncoded + "\u0001" + keyAliasValue), new ColumnVisibility(Metadata.Visiblity.getVisibility((Tuple)tuple, (String)"")), Constants.EMPTY_VALUE);
                    reverse.put(new Text(Direction.IN.toString() + "\u0000" + label), new Text(edgeEncoded + "\u0000" + fromEncoded + "\u0001" + keyAliasValue), new ColumnVisibility(Metadata.Visiblity.getVisibility((Tuple)tuple, (String)"")), Constants.EMPTY_VALUE);
                }
                this.writer.addMutation(forward);
                this.writer.addMutation(reverse);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void flush() throws Exception {
        this.writer.flush();
        super.flush();
    }

    public void shutdown() throws MutationsRejectedException {
        super.shutdown();
        this.writer.close();
    }

    private boolean isEdge(Entity entity) {
        return entity.get("head") != null && entity.get("tail") != null && entity.get("edgeLabel") != null;
    }

    private Connector getConnector() {
        return this.getHelper().getConnector();
    }

    private StoreConfig getConfig() {
        return this.getHelper().getConfig();
    }

    public String toString() {
        return this.getClass().getSimpleName().toLowerCase() + "{" + "table='" + this.table + '\'' + ", bufferSize=" + this.bufferSize + ", writer=" + this.writer + '}';
    }
}

