/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.graphstore.tinkerpop;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Features;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.GraphQuery;
import com.tinkerpop.blueprints.Vertex;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.calrissian.accumulorecipes.commons.domain.Auths;
import org.calrissian.accumulorecipes.graphstore.GraphStore;
import org.calrissian.accumulorecipes.graphstore.model.Direction;
import org.calrissian.accumulorecipes.graphstore.tinkerpop.model.EntityEdge;
import org.calrissian.accumulorecipes.graphstore.tinkerpop.model.EntityElement;
import org.calrissian.accumulorecipes.graphstore.tinkerpop.model.EntityVertex;
import org.calrissian.accumulorecipes.graphstore.tinkerpop.query.EntityGraphQuery;
import org.calrissian.mango.collect.CloseableIterable;
import org.calrissian.mango.collect.CloseableIterables;
import org.calrissian.mango.criteria.builder.QueryBuilder;
import org.calrissian.mango.criteria.domain.criteria.Criteria;
import org.calrissian.mango.domain.TupleStore;
import org.calrissian.mango.domain.entity.Entity;
import org.calrissian.mango.domain.entity.EntityIndex;
import org.calrissian.mango.domain.entity.EntityRelationship;

public class EntityGraph
implements Graph {
    protected GraphStore graphStore;
    protected Set<String> vertexTypes;
    protected Set<String> edgeTypes;
    protected Auths auths;

    public EntityGraph(GraphStore graphStore, Set<String> vertexTypes, Set<String> edgeTypes, Auths auths) {
        this.graphStore = graphStore;
        this.vertexTypes = vertexTypes;
        this.edgeTypes = edgeTypes;
        this.auths = auths;
    }

    public Features getFeatures() {
        Features features = new Features();
        features.supportsTransactions = false;
        features.supportsDuplicateEdges = false;
        features.supportsSelfLoops = true;
        features.supportsSerializableObjectProperty = true;
        features.supportsBooleanProperty = true;
        features.supportsDoubleProperty = true;
        features.supportsFloatProperty = true;
        features.supportsIntegerProperty = true;
        features.supportsPrimitiveArrayProperty = false;
        features.supportsUniformListProperty = false;
        features.supportsMixedListProperty = false;
        features.supportsLongProperty = true;
        features.supportsMapProperty = false;
        features.supportsStringProperty = true;
        features.ignoresSuppliedIds = false;
        features.isPersistent = true;
        features.isWrapper = true;
        features.supportsIndices = true;
        features.supportsVertexIndex = true;
        features.supportsEdgeIndex = true;
        features.supportsKeyIndices = true;
        features.supportsVertexKeyIndex = true;
        features.supportsEdgeKeyIndex = true;
        features.supportsEdgeIteration = true;
        features.supportsVertexIteration = true;
        features.supportsEdgeRetrieval = true;
        features.supportsVertexProperties = true;
        features.supportsEdgeProperties = true;
        features.supportsThreadedTransactions = false;
        features.supportsTransactions = false;
        return features;
    }

    public Vertex addVertex(Object o) {
        throw new UnsupportedOperationException("The Calrissian EntityGraph is immutable. Use the GraphStore API to modify the graph.");
    }

    public Vertex getVertex(Object entityIndex) {
        CloseableIterable entities;
        Iterator itr;
        Preconditions.checkArgument((boolean)(entityIndex instanceof EntityIndex));
        if (this.vertexTypes.contains(((EntityIndex)entityIndex).getType())) {
            // empty if block
        }
        if ((itr = (entities = this.graphStore.get(Collections.singletonList((EntityIndex)entityIndex), null, this.auths)).iterator()).hasNext()) {
            EntityVertex toReturn = new EntityVertex((Entity)itr.next(), this.graphStore, this.auths);
            entities.closeQuietly();
            return toReturn;
        }
        return null;
    }

    public void removeVertex(Vertex vertex) {
        throw new UnsupportedOperationException("The Calrissian EntityGraph is immutable. Use the GraphStore API to modify the graph.");
    }

    public CloseableIterable<Vertex> getVertices() {
        CloseableIterable entities = this.graphStore.getAllByType(this.vertexTypes, null, this.auths);
        return CloseableIterables.transform((CloseableIterable)entities, (Function)new VertexEntityXform(this.graphStore, this.auths));
    }

    public CloseableIterable<Vertex> getVertices(String key, Object value) {
        CloseableIterable entities = this.graphStore.query(this.vertexTypes, new QueryBuilder().eq(key, value).build(), null, this.auths);
        return CloseableIterables.transform((CloseableIterable)entities, (Function)new VertexEntityXform(this.graphStore, this.auths));
    }

    public Edge addEdge(Object o, Vertex vertex, Vertex vertex2, String s) {
        throw new UnsupportedOperationException("The Calrissian EntityGraph is immutable. Use the GraphStore API to modify the graph.");
    }

    public Edge getEdge(Object entityIndex) {
        CloseableIterable entities;
        Iterator itr;
        Preconditions.checkArgument((boolean)(entityIndex instanceof EntityIndex));
        if (this.edgeTypes.contains(((EntityIndex)entityIndex).getType())) {
            // empty if block
        }
        if ((itr = (entities = this.graphStore.get(Collections.singletonList((EntityIndex)entityIndex), null, this.auths)).iterator()).hasNext()) {
            EntityEdge toReturn = new EntityEdge((Entity)itr.next(), this.graphStore, this.auths);
            entities.closeQuietly();
            return toReturn;
        }
        return null;
    }

    public void removeEdge(Edge edge) {
        throw new UnsupportedOperationException("The Calrissian EntityGraph is immutable. Use the GraphStore API to modify the graph.");
    }

    public CloseableIterable<Edge> getEdges() {
        CloseableIterable entities = this.graphStore.getAllByType(this.edgeTypes, null, this.auths);
        return CloseableIterables.transform((CloseableIterable)entities, (Function)new EdgeEntityXform(this.graphStore, this.auths));
    }

    public CloseableIterable<Edge> getEdges(String key, Object value) {
        CloseableIterable entities = this.graphStore.query(this.edgeTypes, new QueryBuilder().eq(key, value).build(), null, this.auths);
        return CloseableIterables.transform((CloseableIterable)entities, (Function)new EdgeEntityXform(this.graphStore, this.auths));
    }

    public GraphQuery query() {
        return new EntityGraphQuery(this.graphStore, this.vertexTypes, this.edgeTypes, this.auths);
    }

    public void shutdown() {
    }

    public String toString() {
        return this.getClass().getSimpleName().toLowerCase() + "{" + "graphStore=" + this.graphStore + ", vertexTypes=" + this.vertexTypes + ", edgeTypes=" + this.edgeTypes + ", auths=" + this.auths + '}';
    }

    public static class EntityFilterPredicate<T extends Element>
    implements Predicate<T> {
        private Criteria criteria;

        public EntityFilterPredicate(Criteria criteria) {
            this.criteria = criteria;
        }

        public boolean apply(T element) {
            return this.criteria.apply((TupleStore)((EntityElement)element).getEntity());
        }
    }

    public static class EdgeToVertexIndexXform
    implements Function<Entity, EntityIndex> {
        private Direction direction;

        public EdgeToVertexIndexXform(Direction direction) {
            this.direction = direction;
        }

        public EntityIndex apply(Entity element) {
            String headOrTail = this.direction == Direction.IN ? "head" : "tail";
            EntityRelationship rel = (EntityRelationship)element.get(headOrTail).getValue();
            return new EntityIndex(rel.getType(), rel.getId());
        }
    }

    public static class EntityIndexXform
    implements Function<Element, EntityIndex> {
        public EntityIndex apply(Element element) {
            Entity entity = ((EntityElement)element).getEntity();
            return new EntityIndex(entity.getType(), entity.getId());
        }
    }

    public static class VertexEntityXform
    implements Function<Entity, Vertex> {
        private GraphStore graphStore;
        private Auths auths;

        public VertexEntityXform(GraphStore graphStore, Auths auths) {
            this.graphStore = graphStore;
            this.auths = auths;
        }

        public Vertex apply(Entity entity) {
            return new EntityVertex(entity, this.graphStore, this.auths);
        }
    }

    public static class EdgeEntityXform
    implements Function<Entity, Edge> {
        private GraphStore graphStore;
        private Auths auths;

        public EdgeEntityXform(GraphStore graphStore, Auths auths) {
            this.graphStore = graphStore;
            this.auths = auths;
        }

        public Edge apply(Entity entity) {
            return new EntityEdge(entity, this.graphStore, this.auths);
        }
    }
}

