/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.graphstore.tinkerpop.query;

import com.google.common.base.Function;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.GraphQuery;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Query;
import com.tinkerpop.blueprints.Vertex;
import java.util.Collection;
import java.util.Set;
import org.calrissian.accumulorecipes.commons.domain.Auths;
import org.calrissian.accumulorecipes.graphstore.GraphStore;
import org.calrissian.accumulorecipes.graphstore.tinkerpop.EntityGraph;
import org.calrissian.mango.collect.CloseableIterable;
import org.calrissian.mango.collect.CloseableIterables;
import org.calrissian.mango.criteria.builder.QueryBuilder;
import org.calrissian.mango.criteria.domain.Node;
import org.calrissian.mango.criteria.support.NodeUtils;
import org.calrissian.mango.domain.entity.Entity;

public class EntityGraphQuery
implements GraphQuery {
    private GraphStore graphStore;
    private Set<String> vertexTypes;
    private Set<String> edgeTypes;
    private Auths auths;
    private int limit = -1;
    private QueryBuilder queryBuilder = new QueryBuilder().and();
    private QueryBuilder filters = new QueryBuilder().and();

    public EntityGraphQuery(GraphStore graphStore, Set<String> vertexTypes, Set<String> edgeTypes, Auths auths) {
        this.graphStore = graphStore;
        this.auths = auths;
        this.vertexTypes = vertexTypes;
        this.edgeTypes = edgeTypes;
    }

    public GraphQuery has(String key) {
        this.queryBuilder = this.queryBuilder.has(key);
        return this;
    }

    public GraphQuery hasNot(String key) {
        this.filters = this.filters.hasNot(key);
        return this;
    }

    public GraphQuery has(String key, Object value) {
        this.queryBuilder = this.queryBuilder.eq(key, value);
        return this;
    }

    public GraphQuery hasNot(String key, Object value) {
        this.queryBuilder = this.queryBuilder.notEq(key, value);
        return this;
    }

    public GraphQuery has(String key, Predicate predicate, Object value) {
        if (predicate.toString().equals("EQUAL")) {
            return this.has(key, value);
        }
        if (predicate.toString().equals("NOT_EQUAL")) {
            return this.hasNot(key, value);
        }
        if (predicate.toString().equals("GREATER_THAN")) {
            this.queryBuilder = this.queryBuilder.greaterThan(key, value);
        } else if (predicate.toString().equals("LESS_THAN")) {
            this.queryBuilder = this.queryBuilder.lessThan(key, value);
        } else if (predicate.toString().equals("GREATER_THAN_EQUAL")) {
            this.queryBuilder = this.queryBuilder.greaterThanEq(key, value);
        } else if (predicate.toString().equals("LESS_THAN_EQUAL")) {
            this.queryBuilder = this.queryBuilder.lessThanEq(key, value);
        } else if (predicate.toString().equals("IN")) {
            this.queryBuilder = this.queryBuilder.in(key, (Collection)value);
        } else if (predicate.toString().equals("NOT_IN")) {
            this.queryBuilder = this.queryBuilder.notIn(key, (Collection)value);
        } else {
            throw new UnsupportedOperationException("Predicate with type " + predicate + " is not supported.");
        }
        return this;
    }

    public <T extends Comparable<T>> GraphQuery has(String key, T value, Query.Compare compare) {
        return this.has(key, (Predicate)compare, value);
    }

    public <T extends Comparable<?>> GraphQuery interval(String key, T start, T stop) {
        this.queryBuilder = this.queryBuilder.range(key, start, stop);
        return this;
    }

    public GraphQuery limit(int i) {
        this.limit = i;
        return this;
    }

    public CloseableIterable<Edge> edges() {
        return this.queryElements(this.edgeTypes, new EntityGraph.EdgeEntityXform(this.graphStore, this.auths));
    }

    public CloseableIterable<Vertex> vertices() {
        return this.queryElements(this.vertexTypes, new EntityGraph.VertexEntityXform(this.graphStore, this.auths));
    }

    private <T> CloseableIterable<T> queryElements(Set<String> elementTypes, Function<Entity, T> function) {
        Node query = this.queryBuilder.end().build();
        Node filter = this.filters.end().build();
        CloseableIterable entities = query.children().size() > 0 ? this.graphStore.query(elementTypes, query, null, this.auths) : this.graphStore.getAllByType(elementTypes, null, this.auths);
        CloseableIterable elements = CloseableIterables.transform((CloseableIterable)entities, function);
        if (filter.children().size() > 0) {
            elements = CloseableIterables.filter((CloseableIterable)elements, new EntityGraph.EntityFilterPredicate(NodeUtils.criteriaFromNode((Node)filter)));
        }
        if (this.limit > -1) {
            return CloseableIterables.limit((CloseableIterable)elements, (int)this.limit);
        }
        return elements;
    }
}

