/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.lastn.impl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.hadoop.io.Text;
import org.calrissian.accumulorecipes.commons.domain.Auths;
import org.calrissian.accumulorecipes.commons.domain.StoreConfig;
import org.calrissian.accumulorecipes.commons.domain.StoreEntry;
import org.calrissian.accumulorecipes.lastn.LastNStore;
import org.calrissian.accumulorecipes.lastn.iterator.EntryIterator;
import org.calrissian.accumulorecipes.lastn.iterator.IndexEntryFilteringIterator;
import org.calrissian.mango.accumulo.types.AccumuloTypeEncoders;
import org.calrissian.mango.domain.Tuple;
import org.calrissian.mango.json.tuple.TupleModule;
import org.calrissian.mango.types.TypeRegistry;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;

public class AccumuloLastNStore
implements LastNStore {
    private static final String DEFAULT_TABLE_NAME = "lastN";
    private static final StoreConfig DEFAULT_STORE_CONFIG = new StoreConfig(1, 100000L, 10000L, 3);
    private static final IteratorSetting EVENT_FILTER_SETTING = new IteratorSetting(40, "eventFilter", IndexEntryFilteringIterator.class);
    private final Connector connector;
    private final String tableName;
    private final BatchWriter writer;
    private final TypeRegistry<String> typeRegistry;
    private final ObjectMapper objectMapper;
    private Function<Map.Entry<Key, Value>, StoreEntry> storeTransform = new Function<Map.Entry<Key, Value>, StoreEntry>(){

        public StoreEntry apply(Map.Entry<Key, Value> entry) {
            try {
                return (StoreEntry)AccumuloLastNStore.this.objectMapper.readValue(entry.getValue().get(), StoreEntry.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    };

    public AccumuloLastNStore(Connector connector) throws TableNotFoundException, AccumuloSecurityException, AccumuloException, TableExistsException {
        this(connector, 100);
    }

    public AccumuloLastNStore(Connector connector, int maxVersions) throws TableNotFoundException, AccumuloSecurityException, AccumuloException, TableExistsException {
        this(connector, DEFAULT_TABLE_NAME, DEFAULT_STORE_CONFIG, maxVersions);
    }

    public AccumuloLastNStore(Connector connector, String tableName, StoreConfig config, int maxVersions) throws TableNotFoundException, TableExistsException, AccumuloSecurityException, AccumuloException {
        Preconditions.checkNotNull((Object)connector);
        Preconditions.checkNotNull((Object)tableName);
        Preconditions.checkNotNull((Object)config);
        this.connector = connector;
        this.tableName = tableName;
        this.typeRegistry = AccumuloTypeEncoders.ACCUMULO_TYPES;
        this.objectMapper = new ObjectMapper().withModule((Module)new TupleModule(this.typeRegistry));
        if (!connector.tableOperations().exists(this.tableName)) {
            connector.tableOperations().create(this.tableName, true);
            this.configureTable(connector, this.tableName, maxVersions);
        }
        this.writer = this.connector.createBatchWriter(this.tableName, config.getMaxMemory(), config.getMaxLatency(), config.getMaxWriteThreads());
    }

    protected void configureTable(Connector connector, String tableName, int maxVersions) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
        connector.tableOperations().attachIterator(tableName, EVENT_FILTER_SETTING, EnumSet.allOf(IteratorUtil.IteratorScope.class));
        connector.tableOperations().setProperty(tableName, "table.iterator.majc.vers.opt.maxVersions", Integer.toString(maxVersions));
        connector.tableOperations().setProperty(tableName, "table.iterator.minc.vers.opt.maxVersions", Integer.toString(maxVersions));
        connector.tableOperations().setProperty(tableName, "table.iterator.scan.vers.opt.maxVersions", Integer.toString(maxVersions));
    }

    public void shutdown() throws MutationsRejectedException {
        this.writer.close();
    }

    @Override
    public void put(String group, StoreEntry entry) {
        Preconditions.checkNotNull((Object)group);
        Preconditions.checkNotNull((Object)entry);
        Mutation indexMutation = new Mutation((CharSequence)group);
        indexMutation.put((CharSequence)"\u0000INDEX", (CharSequence)"", new ColumnVisibility(), entry.getTimestamp(), new Value(entry.getId().getBytes()));
        for (Tuple tuple : entry.getTuples()) {
            String fam = String.format("%s%s", "\uffff", entry.getId());
            Object value = tuple.getValue();
            try {
                String serialize = (String)this.typeRegistry.encode(value);
                String aliasForType = this.typeRegistry.getAlias(value);
                String qual = String.format("%s%s%s%s%s", tuple.getKey(), "\u0000", serialize, "\u0000", aliasForType);
                indexMutation.put((CharSequence)fam, (CharSequence)qual, new ColumnVisibility(tuple.getVisibility()), entry.getTimestamp(), new Value("".getBytes()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            this.writer.addMutation(indexMutation);
        }
        catch (MutationsRejectedException ex) {
            throw new RuntimeException("There was an error writing the mutation for [index=" + group + ",entryId=" + entry.getId() + "]", ex);
        }
    }

    @Override
    public Iterable<StoreEntry> get(String index, Auths auths) {
        Preconditions.checkNotNull((Object)index);
        Preconditions.checkNotNull((Object)auths);
        try {
            Scanner scanner = this.connector.createScanner(this.tableName, auths.getAuths());
            scanner.setRange(new Range((CharSequence)index));
            scanner.fetchColumnFamily(new Text("\u0000INDEX"));
            IteratorSetting iteratorSetting = new IteratorSetting(16, "eventIterator", EntryIterator.class);
            scanner.addScanIterator(iteratorSetting);
            return Iterables.transform((Iterable)scanner, this.storeTransform);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

