/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.lastn.iterator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.WrappingIterator;
import org.apache.hadoop.io.Text;
import org.calrissian.accumulorecipes.commons.domain.StoreEntry;
import org.calrissian.mango.accumulo.types.AccumuloTypeEncoders;
import org.calrissian.mango.domain.Tuple;
import org.calrissian.mango.json.tuple.TupleModule;
import org.calrissian.mango.types.TypeRegistry;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;

public class EntryIterator
extends WrappingIterator {
    private TypeRegistry<String> typeRegistry;
    private ObjectMapper objectMapper;
    private SortedKeyValueIterator<Key, Value> sourceItr;

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        this.sourceItr = source.deepCopy(env);
        this.typeRegistry = AccumuloTypeEncoders.ACCUMULO_TYPES;
        this.objectMapper = new ObjectMapper().withModule((Module)new TupleModule(this.typeRegistry));
    }

    public Value getTopValue() {
        if (this.hasTop()) {
            Key topKey = this.getTopKey();
            Value topVal = super.getTopValue();
            String entryId = new String(topVal.get());
            Key startRangeKey = new Key(topKey.getRow(), new Text("\uffff" + entryId));
            Key stopRangeKey = new Key(topKey.getRow(), new Text("\uffff" + entryId + "\uffff"));
            Range range = new Range(startRangeKey, stopRangeKey);
            long timestamp = 0L;
            try {
                this.sourceItr.seek(range, Collections.emptyList(), false);
                ArrayList<Tuple> tuples = new ArrayList<Tuple>();
                while (this.sourceItr.hasTop()) {
                    Key nextKey = (Key)this.sourceItr.getTopKey();
                    this.sourceItr.next();
                    if (!nextKey.getColumnFamily().toString().endsWith(entryId)) break;
                    String[] keyValueDatatype = nextKey.getColumnQualifier().toString().split("\u0000");
                    if (keyValueDatatype.length != 3) continue;
                    Tuple tuple = new Tuple(keyValueDatatype[0], this.typeRegistry.decode(keyValueDatatype[2], (Object)keyValueDatatype[1]), nextKey.getColumnVisibility().toString());
                    tuples.add(tuple);
                    timestamp = nextKey.getTimestamp();
                }
                StoreEntry entry = new StoreEntry(entryId, timestamp);
                if (tuples.size() > 0) {
                    entry.putAll(tuples);
                }
                return new Value(this.objectMapper.writeValueAsBytes((Object)entry));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return new Value("".getBytes());
    }
}

