/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.lastn.iterator;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Filter;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;

public class IndexEntryFilteringIterator
extends Filter {
    protected HashSet<String> uuidSet = null;
    protected String currentIndex = null;
    protected String previousEvent = null;

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        IndexEntryFilteringIterator copy = (IndexEntryFilteringIterator)super.deepCopy(env);
        copy.currentIndex = this.currentIndex;
        copy.previousEvent = this.previousEvent;
        copy.uuidSet = new HashSet<String>(this.uuidSet);
        return copy;
    }

    public boolean accept(Key key, Value value) {
        try {
            if (key.getColumnFamily().toString().equals("\u0000INDEX")) {
                if (!key.getRow().toString().equals(this.currentIndex)) {
                    this.currentIndex = key.getRow().toString();
                    this.uuidSet = new HashSet();
                }
                this.uuidSet.add(new String(value.get()));
                return true;
            }
            String uuid = key.getColumnFamily().toString().replace("\uffff", "");
            String hash = new String(value.get());
            if (!this.uuidSet.contains(uuid + "\u0000" + hash)) {
                return false;
            }
            String[] keyValue = key.getColumnQualifier().toString().split("\u0000");
            if (this.previousEvent != null && this.previousEvent.equals(key.getRow() + "\u0000" + uuid + "\u0000" + hash + "\u0000" + keyValue[0] + "\u0000" + keyValue[1])) {
                return false;
            }
            this.previousEvent = key.getRow() + "\u0000" + uuid + "\u0000" + hash + "\u0000" + keyValue[0] + "\u0000" + keyValue[1];
        }
        catch (Exception e) {
            return true;
        }
        return true;
    }
}

