/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.lastn.iterator;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.WrappingIterator;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.calrissian.accumulorecipes.commons.hadoop.EventWritable;
import org.calrissian.accumulorecipes.commons.support.WritableUtils2;
import org.calrissian.accumulorecipes.commons.support.tuple.Metadata;
import org.calrissian.mango.domain.Tuple;
import org.calrissian.mango.domain.event.BaseEvent;
import org.calrissian.mango.domain.event.Event;
import org.calrissian.mango.io.Serializables;
import org.calrissian.mango.types.TypeRegistry;

public class EntryIterator
extends WrappingIterator {
    public static final String TYPE_REGISTRY = "typeRegistry";
    private TypeRegistry<String> typeRegistry;
    private SortedKeyValueIterator<Key, Value> sourceItr;
    private EventWritable writable;

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        this.sourceItr = source.deepCopy(env);
        this.typeRegistry = this.getTypeRegistry(options);
        this.writable = new EventWritable();
    }

    public static void setTypeRegistry(IteratorSetting setting, TypeRegistry<String> registry) {
        Preconditions.checkNotNull(registry);
        try {
            setting.addOption(TYPE_REGISTRY, new String(Serializables.toBase64(registry)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private TypeRegistry<String> getTypeRegistry(Map<String, String> options) {
        if (options.containsKey(TYPE_REGISTRY)) {
            try {
                return (TypeRegistry)Serializables.fromBase64((byte[])options.get(TYPE_REGISTRY).getBytes());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Error: Type registry was not configured on iterator.");
    }

    public Value getTopValue() {
        if (this.hasTop()) {
            Key topKey = this.getTopKey();
            Value topVal = super.getTopValue();
            String entryId = new String(topVal.get());
            Key startRangeKey = new Key(topKey.getRow(), new Text("\uffff" + entryId));
            Key stopRangeKey = new Key(topKey.getRow(), new Text("\uffff" + entryId + "\uffff"));
            Range range = new Range(startRangeKey, stopRangeKey);
            long timestamp = 0L;
            try {
                this.sourceItr.seek(range, Collections.emptyList(), false);
                ArrayList<Tuple> tuples = new ArrayList<Tuple>();
                while (this.sourceItr.hasTop()) {
                    Key nextKey = (Key)this.sourceItr.getTopKey();
                    this.sourceItr.next();
                    if (!nextKey.getColumnFamily().toString().endsWith(entryId)) break;
                    String[] keyValueDatatype = nextKey.getColumnQualifier().toString().split("\u0000");
                    if (keyValueDatatype.length != 3) continue;
                    String vis = nextKey.getColumnVisibility().toString();
                    Tuple tuple = new Tuple(keyValueDatatype[0], this.typeRegistry.decode(keyValueDatatype[2], (Object)keyValueDatatype[1]), Metadata.Visiblity.setVisibility(new HashMap(1), (String)vis));
                    tuples.add(tuple);
                    timestamp = nextKey.getTimestamp();
                }
                BaseEvent entry = new BaseEvent(entryId, timestamp);
                this.writable.set((Event)entry);
                if (tuples.size() > 0) {
                    entry.putAll(tuples);
                }
                return new Value(WritableUtils2.serialize((Writable)this.writable));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return new Value("".getBytes());
    }
}

