/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.metricsstore.ext.custom.domain;

import com.google.common.base.Preconditions;

public class CustomMetric<T> {
    private final long timestamp;
    private final String group;
    private final String type;
    private final String name;
    private final String visibility;
    private final T value;

    public CustomMetric(long timestamp, String group, String type, String name, String visibility, T value) {
        Preconditions.checkNotNull((Object)group);
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)visibility);
        Preconditions.checkNotNull(value);
        this.timestamp = timestamp;
        this.group = group;
        this.type = type;
        this.name = name;
        this.visibility = visibility;
        this.value = value;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getGroup() {
        return this.group;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public T getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomMetric that = (CustomMetric)o;
        if (this.timestamp != that.timestamp) {
            return false;
        }
        if (!this.group.equals(that.group)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.type.equals(that.type)) {
            return false;
        }
        if (!this.value.equals(that.value)) {
            return false;
        }
        return this.visibility.equals(that.visibility);
    }

    public int hashCode() {
        int result = (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + this.group.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.visibility.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public String toString() {
        return "CustomMetric{timestamp=" + this.timestamp + ", group='" + this.group + '\'' + ", type='" + this.type + '\'' + ", name='" + this.name + '\'' + ", visibility='" + this.visibility + '\'' + ", value=" + this.value + '}';
    }
}

