/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.metricsstore.ext.custom.function;

import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.calrissian.accumulorecipes.metricsstore.ext.custom.function.MetricFunction;

public class StatsFunction
implements MetricFunction<long[]> {
    long[] stats;

    @Override
    public void reset() {
        this.stats = new long[]{Long.MAX_VALUE, Long.MIN_VALUE, 0L, 0L, 0L};
    }

    @Override
    public void update(long value) {
        this.stats[0] = Math.min(this.stats[0], value);
        this.stats[1] = Math.max(this.stats[1], value);
        this.stats[2] = this.stats[2] + value;
        this.stats[3] = this.stats[3] + 1L;
        this.stats[4] = this.stats[4] + value * value;
    }

    @Override
    public void merge(long[] value) {
        this.stats[0] = Math.min(this.stats[0], value[0]);
        this.stats[1] = Math.max(this.stats[1], value[1]);
        this.stats[2] = this.stats[2] + value[2];
        this.stats[3] = this.stats[3] + value[3];
        this.stats[4] = this.stats[4] + value[4];
    }

    @Override
    public byte[] serialize() {
        return StringUtils.join(Arrays.asList(Long.toString(this.stats[0]), Long.toString(this.stats[1]), Long.toString(this.stats[2]), Long.toString(this.stats[3]), Long.toString(this.stats[4])), (String)",").getBytes();
    }

    @Override
    public long[] deserialize(byte[] data) {
        String[] individual = new String(data).split(",");
        if (individual.length != 5) {
            throw new IllegalStateException("Invalid number of elements in combiner function");
        }
        long[] retVal = new long[5];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = Long.parseLong(individual[i]);
        }
        return retVal;
    }
}

