/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.metricsstore.ext.custom.impl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Date;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.LongCombiner;
import org.apache.accumulo.core.iterators.user.SummingCombiner;
import org.calrissian.accumulorecipes.commons.domain.Auths;
import org.calrissian.accumulorecipes.commons.domain.StoreConfig;
import org.calrissian.accumulorecipes.commons.support.MetricTimeUnit;
import org.calrissian.accumulorecipes.metricsstore.domain.Metric;
import org.calrissian.accumulorecipes.metricsstore.ext.custom.CustomMetricStore;
import org.calrissian.accumulorecipes.metricsstore.ext.custom.domain.CustomMetric;
import org.calrissian.accumulorecipes.metricsstore.ext.custom.function.MetricFunction;
import org.calrissian.accumulorecipes.metricsstore.ext.custom.iterator.FunctionCombiner;
import org.calrissian.accumulorecipes.metricsstore.impl.AccumuloMetricStore;
import org.calrissian.accumulorecipes.metricsstore.support.MetricTransform;
import org.calrissian.mango.accumulo.Scanners;
import org.calrissian.mango.collect.CloseableIterable;
import org.calrissian.mango.collect.CloseableIterables;

public class AccumuloCustomMetricStore
extends AccumuloMetricStore
implements CustomMetricStore {
    private static final String DEFAULT_TABLE_NAME = "custom_metrics";

    public AccumuloCustomMetricStore(Connector connector) throws TableNotFoundException, TableExistsException, AccumuloSecurityException, AccumuloException {
        super(connector, DEFAULT_TABLE_NAME, DEFAULT_STORE_CONFIG);
    }

    public AccumuloCustomMetricStore(Connector connector, String tableName, StoreConfig config) throws TableNotFoundException, TableExistsException, AccumuloSecurityException, AccumuloException {
        super(connector, tableName, config);
    }

    @Override
    protected void configureTable(Connector connector, String tableName) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
    }

    @Override
    public CloseableIterable<Metric> query(Date start, Date end, String group, String type, String name, MetricTimeUnit timeUnit, Auths auths) {
        ScannerBase scanner = this.metricScanner(start, end, group, type, name, timeUnit, auths);
        IteratorSetting setting = new IteratorSetting(15, "stats", SummingCombiner.class);
        SummingCombiner.setColumns((IteratorSetting)setting, Arrays.asList(new IteratorSetting.Column(timeUnit.toString())));
        SummingCombiner.setEncodingType((IteratorSetting)setting, (LongCombiner.Type)LongCombiner.Type.STRING);
        scanner.addScanIterator(setting);
        return CloseableIterables.transform((CloseableIterable)Scanners.closeableIterable((ScannerBase)scanner), (Function)new MetricTransform<Metric>(timeUnit){

            @Override
            protected Metric transform(long timestamp, String group, String type, String name, String visibility, Value value) {
                return new Metric(timestamp, group, type, name, visibility, Long.parseLong(value.toString()));
            }
        });
    }

    @Override
    public <T> CloseableIterable<CustomMetric<T>> queryCustom(Date start, Date end, String group, String type, String name, Class<? extends MetricFunction<T>> function, MetricTimeUnit timeUnit, Auths auths) throws IllegalAccessException, InstantiationException {
        Preconditions.checkNotNull(function);
        MetricFunction<T> impl = function.newInstance();
        ScannerBase scanner = this.metricScanner(start, end, group, type, name, timeUnit, auths);
        IteratorSetting setting = new IteratorSetting(15, "functionCombiner", FunctionCombiner.class);
        FunctionCombiner.setFunctionClass(setting, function);
        FunctionCombiner.setColumns((IteratorSetting)setting, Arrays.asList(new IteratorSetting.Column(timeUnit.toString())));
        scanner.addScanIterator(setting);
        return CloseableIterables.transform((CloseableIterable)Scanners.closeableIterable((ScannerBase)scanner), new CustomMetricTransform<T>(timeUnit, impl));
    }

    private static class CustomMetricTransform<T>
    extends MetricTransform<CustomMetric<T>> {
        MetricFunction<T> function;

        public CustomMetricTransform(MetricTimeUnit timeUnit, MetricFunction<T> function) {
            super(timeUnit);
            this.function = function;
        }

        @Override
        protected CustomMetric<T> transform(long timestamp, String group, String type, String name, String visibility, Value value) {
            byte[] data = value.get();
            return new CustomMetric<T>(timestamp, group, type, name, visibility, this.function.deserialize(Arrays.copyOfRange(data, 1, data.length)));
        }
    }
}

