/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.metricsstore.ext.custom.iterator;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Combiner;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.calrissian.accumulorecipes.metricsstore.ext.custom.function.MetricFunction;

public class FunctionCombiner
extends Combiner {
    private static final String PREFIX = "\u0000";
    public static final String FUNCTION_CLASS = "functionClass";
    private MetricFunction function;

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        if (!options.containsKey(FUNCTION_CLASS)) {
            throw new IllegalArgumentException("Property expected: functionClass");
        }
        try {
            this.function = (MetricFunction)Thread.currentThread().getContextClassLoader().loadClass(options.get(FUNCTION_CLASS)).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> void setFunctionClass(IteratorSetting is, Class<? extends MetricFunction<T>> functionClazz) {
        is.addOption(FUNCTION_CLASS, functionClazz.getName());
    }

    public Value reduce(Key key, Iterator<Value> iter) {
        byte[] data;
        if (!iter.hasNext()) {
            return new Value();
        }
        this.function.reset();
        while (iter.hasNext()) {
            data = iter.next().get();
            if (data.length <= 0) continue;
            if (data[0] == 0) {
                this.function.merge(this.function.deserialize(Arrays.copyOfRange(data, 1, data.length)));
                continue;
            }
            this.function.update(Long.parseLong(new String(data)));
        }
        data = this.function.serialize();
        byte[] prefixed = new byte[data.length + 1];
        prefixed[0] = 0;
        for (int i = 0; i < data.length; ++i) {
            prefixed[i + 1] = data[i];
        }
        return new Value(prefixed);
    }
}

