/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.metricsstore.ext.stats.domain;

import com.google.common.base.Preconditions;

public class Stats {
    private final long timestamp;
    private final String group;
    private final String type;
    private final String name;
    private final String visibility;
    private final long min;
    private final long max;
    private final long sum;
    private final long count;
    private final long sumSquare;

    public Stats(long timestamp, String group, String type, String name, String visibility, long min, long max, long sum, long count, long sumSquare) {
        Preconditions.checkNotNull((Object)group);
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)visibility);
        this.timestamp = timestamp;
        this.group = group;
        this.type = type;
        this.name = name;
        this.visibility = visibility;
        this.min = min;
        this.max = max;
        this.sum = sum;
        this.count = count;
        this.sumSquare = sumSquare;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getGroup() {
        return this.group;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public long getSum() {
        return this.sum;
    }

    public long getCount() {
        return this.count;
    }

    public long getSumSquare() {
        return this.sumSquare;
    }

    public double getMean() {
        if (this.count < 1L) {
            return 0.0;
        }
        return (double)this.sum / (double)this.count;
    }

    public double getVariance() {
        return this.getVariance(false);
    }

    public double getVariance(boolean asSample) {
        if (asSample) {
            if (this.count < 2L) {
                return 0.0;
            }
            return (double)this.sumSquare / (double)(this.count - 1L) - this.getMean() * ((double)this.sum / (double)(this.count - 1L));
        }
        if (this.count < 1L) {
            return 0.0;
        }
        return (double)this.sumSquare / (double)this.count - this.getMean() * this.getMean();
    }

    public double getStdDev() {
        return this.getStdDev(false);
    }

    public double getStdDev(boolean asSample) {
        return Math.sqrt(this.getVariance(asSample));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Stats)) {
            return false;
        }
        Stats stats = (Stats)o;
        if (this.count != stats.count) {
            return false;
        }
        if (this.max != stats.max) {
            return false;
        }
        if (this.min != stats.min) {
            return false;
        }
        if (this.sum != stats.sum) {
            return false;
        }
        if (this.sumSquare != stats.sumSquare) {
            return false;
        }
        if (this.timestamp != stats.timestamp) {
            return false;
        }
        if (!this.group.equals(stats.group)) {
            return false;
        }
        if (!this.name.equals(stats.name)) {
            return false;
        }
        if (!this.type.equals(stats.type)) {
            return false;
        }
        return this.visibility.equals(stats.visibility);
    }

    public int hashCode() {
        int result = (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + this.group.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.visibility.hashCode();
        result = 31 * result + (int)(this.min ^ this.min >>> 32);
        result = 31 * result + (int)(this.max ^ this.max >>> 32);
        result = 31 * result + (int)(this.sum ^ this.sum >>> 32);
        result = 31 * result + (int)(this.count ^ this.count >>> 32);
        result = 31 * result + (int)(this.sumSquare ^ this.sumSquare >>> 32);
        return result;
    }

    public String toString() {
        return "Stats{timestamp=" + this.timestamp + ", group='" + this.group + '\'' + ", type='" + this.type + '\'' + ", name='" + this.name + '\'' + ", visibility='" + this.visibility + '\'' + ", min=" + this.min + ", max=" + this.max + ", sum=" + this.sum + ", count=" + this.count + ", sumSquare=" + this.sumSquare + '}';
    }
}

