/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.metricsstore.ext.stats.impl;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.commons.lang.StringUtils;
import org.calrissian.accumulorecipes.commons.domain.Auths;
import org.calrissian.accumulorecipes.commons.domain.StoreConfig;
import org.calrissian.accumulorecipes.commons.support.MetricTimeUnit;
import org.calrissian.accumulorecipes.metricsstore.domain.Metric;
import org.calrissian.accumulorecipes.metricsstore.ext.stats.StatsMetricStore;
import org.calrissian.accumulorecipes.metricsstore.ext.stats.domain.Stats;
import org.calrissian.accumulorecipes.metricsstore.ext.stats.iterator.StatsCombiner;
import org.calrissian.accumulorecipes.metricsstore.impl.AccumuloMetricStore;
import org.calrissian.accumulorecipes.metricsstore.support.MetricTransform;
import org.calrissian.mango.accumulo.Scanners;
import org.calrissian.mango.collect.CloseableIterable;
import org.calrissian.mango.collect.CloseableIterables;

public class AccumuloStatsMetricStore
extends AccumuloMetricStore
implements StatsMetricStore {
    private static final String DEFAULT_TABLE_NAME = "stats_metrics";

    public AccumuloStatsMetricStore(Connector connector) throws TableNotFoundException, TableExistsException, AccumuloSecurityException, AccumuloException {
        super(connector, DEFAULT_TABLE_NAME, DEFAULT_STORE_CONFIG);
    }

    public AccumuloStatsMetricStore(Connector connector, String tableName, StoreConfig config) throws TableNotFoundException, TableExistsException, AccumuloSecurityException, AccumuloException {
        super(connector, tableName, config);
    }

    @Override
    protected void configureTable(Connector connector, String tableName) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
        ArrayList<IteratorSetting.Column> columns = new ArrayList<IteratorSetting.Column>();
        for (MetricTimeUnit timeUnit : MetricTimeUnit.values()) {
            columns.add(new IteratorSetting.Column(timeUnit.toString()));
        }
        IteratorSetting setting = new IteratorSetting(15, "stats", StatsCombiner.class);
        StatsCombiner.setColumns((IteratorSetting)setting, columns);
        connector.tableOperations().attachIterator(tableName, setting, EnumSet.allOf(IteratorUtil.IteratorScope.class));
    }

    @Override
    public CloseableIterable<Metric> query(Date start, Date end, String group, String type, String name, MetricTimeUnit timeUnit, Auths auths) {
        return CloseableIterables.transform(this.queryStats(start, end, group, type, name, timeUnit, auths), (Function)new Function<Stats, Metric>(){

            public Metric apply(Stats stat) {
                return new Metric(stat.getTimestamp(), stat.getGroup(), stat.getType(), stat.getName(), stat.getVisibility(), stat.getSum());
            }
        });
    }

    @Override
    public CloseableIterable<Stats> queryStats(Date start, Date end, String group, String type, String name, MetricTimeUnit timeUnit, Auths auths) {
        return CloseableIterables.transform((CloseableIterable)Scanners.closeableIterable((ScannerBase)this.metricScanner(start, end, group, type, name, timeUnit, auths)), (Function)new MetricStatsTransform(timeUnit));
    }

    private static class MetricStatsTransform
    extends MetricTransform<Stats> {
        public MetricStatsTransform(MetricTimeUnit timeUnit) {
            super(timeUnit);
        }

        @Override
        protected Stats transform(long timestamp, String group, String type, String name, String visibility, Value value) {
            String[] values = StringUtils.splitPreserveAllTokens((String)value.toString(), (String)",");
            return new Stats(timestamp, group, type, name, visibility, Long.parseLong(values[0]), Long.parseLong(values[1]), Long.parseLong(values[2]), Long.parseLong(values[3]), Long.parseLong(values[4]));
        }
    }
}

