/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.metricsstore.ext.stats.iterator;

import java.util.Iterator;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Combiner;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.commons.lang.StringUtils;

public class StatsCombiner
extends Combiner {
    private String join(String seperator, String ... values) {
        return StringUtils.join((Object[])values, (String)seperator);
    }

    public Value reduce(Key key, Iterator<Value> iter) {
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        long sum = 0L;
        long count = 0L;
        long sumSquare = 0L;
        while (iter.hasNext()) {
            String[] stats = iter.next().toString().split(",");
            if (stats.length == 1) {
                long val = Long.parseLong(stats[0]);
                min = Math.min(val, min);
                max = Math.max(val, max);
                sum += val;
                ++count;
                sumSquare += val * val;
                continue;
            }
            min = Math.min(Long.parseLong(stats[0]), min);
            max = Math.max(Long.parseLong(stats[1]), max);
            sum += Long.parseLong(stats[2]);
            count += Long.parseLong(stats[3]);
            sumSquare += Long.parseLong(stats[4]);
        }
        String ret = this.join(",", Long.toString(min), Long.toString(max), Long.toString(sum), Long.toString(count), Long.toString(sumSquare));
        return new Value(ret.getBytes());
    }

    public OptionDescriber.IteratorOptions describeOptions() {
        OptionDescriber.IteratorOptions io = super.describeOptions();
        io.setName("statsCombiner");
        io.setDescription("Combiner that keeps track of min, max, sum, and count");
        return io;
    }
}

