/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.metricsstore.hadoop;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.calrissian.accumulorecipes.metricsstore.domain.Metric;

public class MetricWritable
implements Writable {
    private Metric metric;

    public MetricWritable() {
    }

    public MetricWritable(Metric metric) {
        this.metric = metric;
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeLong(this.metric.getTimestamp());
        dataOutput.writeUTF(this.metric.getGroup());
        dataOutput.writeUTF(this.metric.getType());
        dataOutput.writeUTF(this.metric.getName());
        dataOutput.writeUTF(this.metric.getVisibility());
        dataOutput.writeLong(this.metric.getValue());
    }

    public void readFields(DataInput dataInput) throws IOException {
        long timestamp = dataInput.readLong();
        String group = dataInput.readUTF();
        String type = dataInput.readUTF();
        String name = dataInput.readUTF();
        String visibility = dataInput.readUTF();
        long value = dataInput.readLong();
        this.metric = new Metric(timestamp, group, type, name, visibility, value);
    }

    public Metric get() {
        return this.metric;
    }

    public void set(Metric metric) {
        this.metric = metric;
    }
}

