/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.metricsstore.hadoop;

import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.mapreduce.InputFormatBase;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.user.RegExFilter;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.format.DefaultFormatter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.calrissian.accumulorecipes.commons.support.MetricTimeUnit;
import org.calrissian.accumulorecipes.commons.support.TimestampUtil;
import org.calrissian.accumulorecipes.metricsstore.domain.Metric;
import org.calrissian.accumulorecipes.metricsstore.hadoop.MetricWritable;
import org.calrissian.accumulorecipes.metricsstore.impl.AccumuloMetricStore;
import org.calrissian.accumulorecipes.metricsstore.support.MetricTransform;

public class MetricsInputFormat
extends InputFormatBase<Key, MetricWritable> {
    public static void setInputInfo(Configuration config, String username, byte[] password, Authorizations auths) {
        MetricsInputFormat.setInputInfo((Configuration)config, (String)username, (byte[])password, (String)"metrics", (Authorizations)auths);
    }

    public static void setQueryInfo(Configuration config, Date start, Date end, MetricTimeUnit timeUnit, String group, String type, String name) {
        config.set("timeUnit", timeUnit.toString());
        MetricsInputFormat.setRanges((Configuration)config, Collections.singleton(new Range((CharSequence)AccumuloMetricStore.combine(group, TimestampUtil.generateTimestamp((long)end.getTime(), (MetricTimeUnit)timeUnit)), (CharSequence)AccumuloMetricStore.combine(group, TimestampUtil.generateTimestamp((long)start.getTime(), (MetricTimeUnit)timeUnit)))));
        if (name != null) {
            Pair column = new Pair((Object)new Text(timeUnit.toString()), (Object)new Text(AccumuloMetricStore.combine(type, name)));
            MetricsInputFormat.fetchColumns((Configuration)config, Collections.singleton(column));
        } else {
            Pair column = new Pair((Object)new Text(timeUnit.toString()), null);
            MetricsInputFormat.fetchColumns((Configuration)config, Collections.singleton(column));
            String cqRegex = null;
            cqRegex = AccumuloMetricStore.combine(group, "(.*)");
            IteratorSetting regexIterator = new IteratorSetting(14, "regex", RegExFilter.class);
            RegExFilter.setRegexs((IteratorSetting)regexIterator, null, null, (String)cqRegex, null, (boolean)false);
            MetricsInputFormat.addIterator((Configuration)config, (IteratorSetting)regexIterator);
        }
    }

    public RecordReader<Key, MetricWritable> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        final MetricTransform<Metric> xform = new MetricTransform<Metric>(MetricTimeUnit.valueOf((String)context.getConfiguration().get("timeUnit"))){

            @Override
            protected Metric transform(long timestamp, String type, String group, String name, String visibility, Value value) {
                return new Metric(timestamp, group, type, name, visibility, Long.parseLong(value.toString()));
            }
        };
        final MetricWritable sharedWritable = new MetricWritable();
        return new InputFormatBase.RecordReaderBase<Key, MetricWritable>(){

            public boolean nextKeyValue() throws IOException, InterruptedException {
                if (this.scannerIterator.hasNext()) {
                    ++this.numKeysRead;
                    Map.Entry entry = (Map.Entry)this.scannerIterator.next();
                    this.currentKey = (Key)entry.getKey();
                    this.currentK = this.currentKey;
                    sharedWritable.set((Metric)xform.apply(entry));
                    this.currentV = sharedWritable;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Processing key/value pair: " + DefaultFormatter.formatEntry((Map.Entry)entry, (boolean)true)));
                    }
                    return true;
                }
                return false;
            }
        };
    }
}

