/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.metricsstore.impl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.LongCombiner;
import org.apache.accumulo.core.iterators.user.RegExFilter;
import org.apache.accumulo.core.iterators.user.SummingCombiner;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.io.Text;
import org.calrissian.accumulorecipes.commons.domain.Auths;
import org.calrissian.accumulorecipes.commons.domain.StoreConfig;
import org.calrissian.accumulorecipes.commons.support.MetricTimeUnit;
import org.calrissian.accumulorecipes.commons.support.TimestampUtil;
import org.calrissian.accumulorecipes.metricsstore.MetricStore;
import org.calrissian.accumulorecipes.metricsstore.domain.Metric;
import org.calrissian.accumulorecipes.metricsstore.support.MetricTransform;
import org.calrissian.mango.accumulo.Scanners;
import org.calrissian.mango.collect.CloseableIterable;
import org.calrissian.mango.collect.CloseableIterables;

public class AccumuloMetricStore
implements MetricStore {
    public static final String DEFAULT_TABLE_NAME = "metrics";
    public static final String REVERSE_SUFFIX = "_reverse";
    protected static final StoreConfig DEFAULT_STORE_CONFIG = new StoreConfig(1, 100000L, 100L, 10);
    private final Connector connector;
    private final StoreConfig config;
    private final String tableName;
    private final BatchWriter groupWriter;
    private final BatchWriter typeWriter;

    public AccumuloMetricStore(Connector connector) throws TableNotFoundException, TableExistsException, AccumuloSecurityException, AccumuloException {
        this(connector, DEFAULT_TABLE_NAME, DEFAULT_STORE_CONFIG);
    }

    public AccumuloMetricStore(Connector connector, String tableName, StoreConfig config) throws TableNotFoundException, TableExistsException, AccumuloSecurityException, AccumuloException {
        Preconditions.checkNotNull((Object)connector);
        Preconditions.checkNotNull((Object)tableName);
        Preconditions.checkNotNull((Object)config);
        this.connector = connector;
        this.tableName = tableName;
        this.config = config;
        this.createTable(this.tableName);
        this.createTable(this.tableName + REVERSE_SUFFIX);
        this.groupWriter = this.connector.createBatchWriter(tableName, config.getMaxMemory(), config.getMaxLatency(), config.getMaxWriteThreads());
        this.typeWriter = this.connector.createBatchWriter(tableName + REVERSE_SUFFIX, config.getMaxMemory(), config.getMaxLatency(), config.getMaxWriteThreads());
    }

    private void createTable(String tableName) throws TableExistsException, AccumuloSecurityException, AccumuloException, TableNotFoundException {
        if (!this.connector.tableOperations().exists(tableName)) {
            this.connector.tableOperations().create(tableName, false);
            this.configureTable(this.connector, tableName);
        }
    }

    public static String combine(String ... items) {
        if (items == null) {
            return null;
        }
        return StringUtils.join((Object[])items, (String)"\u0000");
    }

    protected void configureTable(Connector connector, String tableName) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
        ArrayList<IteratorSetting.Column> columns = new ArrayList<IteratorSetting.Column>();
        for (MetricTimeUnit timeUnit : MetricTimeUnit.values()) {
            columns.add(new IteratorSetting.Column(timeUnit.toString()));
        }
        IteratorSetting setting = new IteratorSetting(15, "stats", SummingCombiner.class);
        SummingCombiner.setColumns((IteratorSetting)setting, columns);
        SummingCombiner.setEncodingType((IteratorSetting)setting, (LongCombiner.Type)LongCombiner.Type.STRING);
        connector.tableOperations().attachIterator(tableName, setting, EnumSet.allOf(IteratorUtil.IteratorScope.class));
    }

    protected ScannerBase metricScanner(Date start, Date end, String group, String type, String name, MetricTimeUnit timeUnit, Auths auths) {
        Preconditions.checkNotNull((Object)group);
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull((Object)start);
        Preconditions.checkNotNull((Object)end);
        Preconditions.checkNotNull((Object)auths);
        try {
            group = StringUtils.defaultString((String)group);
            timeUnit = timeUnit == null ? MetricTimeUnit.MINUTES : timeUnit;
            BatchScanner scanner = this.connector.createBatchScanner(this.tableName + REVERSE_SUFFIX, auths.getAuths(), this.config.getMaxQueryThreads());
            scanner.setRanges(Collections.singleton(new Range((CharSequence)AccumuloMetricStore.combine(type, TimestampUtil.generateTimestamp((long)end.getTime(), (MetricTimeUnit)timeUnit)), (CharSequence)AccumuloMetricStore.combine(type, TimestampUtil.generateTimestamp((long)start.getTime(), (MetricTimeUnit)timeUnit)))));
            if (name != null) {
                scanner.fetchColumn(new Text(timeUnit.toString()), new Text(AccumuloMetricStore.combine(group, name)));
            } else {
                scanner.fetchColumnFamily(new Text(timeUnit.toString()));
                String cqRegex = null;
                cqRegex = AccumuloMetricStore.combine(group, "(.*)");
                IteratorSetting regexIterator = new IteratorSetting(14, "regex", RegExFilter.class);
                RegExFilter.setRegexs((IteratorSetting)regexIterator, null, null, (String)cqRegex, null, (boolean)false);
                scanner.addScanIterator(regexIterator);
            }
            return scanner;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void shutdown() throws MutationsRejectedException {
        this.groupWriter.close();
    }

    @Override
    public void save(Iterable<Metric> metricData) {
        try {
            for (Metric metric : metricData) {
                if (metric == null) continue;
                String group = StringUtils.defaultString((String)metric.getGroup());
                String type = StringUtils.defaultString((String)metric.getType());
                String name = StringUtils.defaultString((String)metric.getName());
                ColumnVisibility visibility = new ColumnVisibility(StringUtils.defaultString((String)metric.getVisibility()));
                for (MetricTimeUnit timeUnit : MetricTimeUnit.values()) {
                    String timestamp = TimestampUtil.generateTimestamp((long)metric.getTimestamp(), (MetricTimeUnit)timeUnit);
                    Mutation group_mutation = new Mutation((CharSequence)AccumuloMetricStore.combine(group, timestamp));
                    Mutation type_mutation = new Mutation((CharSequence)AccumuloMetricStore.combine(type, timestamp));
                    group_mutation.put((CharSequence)timeUnit.toString(), (CharSequence)AccumuloMetricStore.combine(type, name), visibility, metric.getTimestamp(), new Value(Long.toString(metric.getValue()).getBytes()));
                    type_mutation.put((CharSequence)timeUnit.toString(), (CharSequence)AccumuloMetricStore.combine(group, name), visibility, metric.getTimestamp(), new Value(Long.toString(metric.getValue()).getBytes()));
                    this.groupWriter.addMutation(group_mutation);
                    this.typeWriter.addMutation(type_mutation);
                }
            }
            this.groupWriter.flush();
            this.typeWriter.flush();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CloseableIterable<Metric> query(Date start, Date end, String group, String type, String name, MetricTimeUnit timeUnit, Auths auths) {
        return CloseableIterables.transform((CloseableIterable)Scanners.closeableIterable((ScannerBase)this.metricScanner(start, end, group, type, name, timeUnit, auths)), (Function)new MetricTransform<Metric>(timeUnit){

            @Override
            protected Metric transform(long timestamp, String group, String type, String name, String visibility, Value value) {
                return new Metric(timestamp, group, type, name, visibility, Long.parseLong(value.toString()));
            }
        });
    }
}

