/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.rangestore.impl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.io.Text;
import org.calrissian.accumulorecipes.commons.domain.Auths;
import org.calrissian.accumulorecipes.commons.domain.StoreConfig;
import org.calrissian.accumulorecipes.rangestore.RangeStore;
import org.calrissian.accumulorecipes.rangestore.helper.RangeHelper;
import org.calrissian.accumulorecipes.rangestore.iterator.OverlappingScanFilter;
import org.calrissian.accumulorecipes.rangestore.iterator.ReverseScanFilter;
import org.calrissian.mango.collect.Iterables2;
import org.calrissian.mango.domain.ValueRange;

public class AccumuloRangeStore<T extends Comparable<T>>
implements RangeStore<T> {
    private static final String DEFAULT_TABLE_NAME = "ranges";
    private static final StoreConfig DEFAULT_STORE_CONFIG = new StoreConfig(1, 10000L, 10000L, 10);
    private static final String LOWER_BOUND_INDEX = "l";
    private static final String UPPER_BOUND_INDEX = "u";
    private static final String DISTANCE_INDEX = "d";
    private final Connector connector;
    private final String tableName;
    private final BatchWriter writer;
    private final RangeHelper<T> helper;

    public AccumuloRangeStore(Connector connector, RangeHelper<T> helper) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TableExistsException {
        this(connector, DEFAULT_TABLE_NAME, DEFAULT_STORE_CONFIG, helper);
    }

    public AccumuloRangeStore(Connector connector, String tableName, StoreConfig config, RangeHelper<T> helper) throws TableExistsException, AccumuloSecurityException, AccumuloException, TableNotFoundException {
        Preconditions.checkNotNull((Object)connector, (Object)"Invalid connector");
        Preconditions.checkNotNull((Object)tableName, (Object)"The table name must not be empty");
        Preconditions.checkNotNull((Object)config, (Object)"Invalid store configuration");
        this.connector = connector;
        this.tableName = tableName;
        this.helper = helper;
        if (!connector.tableOperations().exists(this.tableName)) {
            connector.tableOperations().create(this.tableName);
            this.configureTable(connector, this.tableName);
        }
        this.writer = connector.createBatchWriter(this.tableName, config.getMaxMemory(), config.getMaxLatency(), config.getMaxWriteThreads());
    }

    protected void configureTable(Connector connector, String tableName) throws AccumuloSecurityException, AccumuloException, TableNotFoundException {
    }

    public void shutdown() throws MutationsRejectedException {
        this.writer.close();
    }

    @Override
    public void save(Iterable<ValueRange<T>> ranges) {
        Preconditions.checkNotNull(ranges);
        try {
            for (ValueRange<T> range : ranges) {
                Preconditions.checkState((boolean)this.helper.isValid(range), (Object)("Invalid Range:" + range.toString()));
                String low = this.helper.encode((Comparable)range.getStart());
                String high = this.helper.encode((Comparable)range.getStop());
                Mutation forwardRange = new Mutation((CharSequence)("l\u0000" + low + "\u0000" + high));
                forwardRange.put(new Text(""), new Text(""), new Value("".getBytes()));
                Mutation reverseRange = new Mutation((CharSequence)("u\u0000" + high + "\u0000" + low));
                reverseRange.put(new Text(""), new Text(""), new Value("".getBytes()));
                String distanceComplement = this.helper.encodeComplement(this.helper.distance(range));
                Mutation distanceMut = new Mutation((CharSequence)("d\u0000" + distanceComplement));
                distanceMut.put(new Text(low), new Text(high), new Value("".getBytes()));
                this.writer.addMutation(forwardRange);
                this.writer.addMutation(reverseRange);
                this.writer.addMutation(distanceMut);
            }
            this.writer.flush();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void delete(Iterable<ValueRange<T>> ranges) {
        Preconditions.checkNotNull(ranges);
        try {
            for (ValueRange<T> range : ranges) {
                Preconditions.checkState((boolean)this.helper.isValid(range), (Object)("Invalid Range:" + range.toString()));
                String low = this.helper.encode((Comparable)range.getStart());
                String high = this.helper.encode((Comparable)range.getStop());
                Mutation forwardRange = new Mutation((CharSequence)("l\u0000" + low + "\u0000" + high));
                forwardRange.putDelete(new Text(""), new Text(""));
                Mutation reverseRange = new Mutation((CharSequence)("u\u0000" + high + "\u0000" + low));
                reverseRange.putDelete(new Text(""), new Text(""));
                String distanceComplement = this.helper.encodeComplement(this.helper.distance(range));
                Mutation distanceMut = new Mutation((CharSequence)("d\u0000" + distanceComplement));
                distanceMut.putDelete(new Text(low), new Text(high));
                this.writer.addMutation(forwardRange);
                this.writer.addMutation(reverseRange);
                this.writer.addMutation(distanceMut);
            }
            this.writer.flush();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private T getMaxDistance(Authorizations auths) throws TableNotFoundException {
        Scanner scanner = this.connector.createScanner(this.tableName, auths);
        scanner.setRange(Range.prefix((CharSequence)DISTANCE_INDEX));
        scanner.setBatchSize(1);
        Iterator iterator = scanner.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        Map.Entry entry = (Map.Entry)iterator.next();
        return this.helper.decodeComplement(((Key)entry.getKey()).getRow().toString().split("\u0000")[1]);
    }

    private Iterable<ValueRange<T>> forwardScan(ValueRange<T> queryRange, Authorizations auths) throws TableNotFoundException {
        Scanner scanner = this.connector.createScanner(this.tableName, auths);
        scanner.setRange(new Range((CharSequence)("l\u0000" + this.helper.encode((Comparable)queryRange.getStart()) + "\u0000"), (CharSequence)("l\u0000" + this.helper.encode((Comparable)queryRange.getStop()) + "\u0000" + "\uffff")));
        return Iterables.transform((Iterable)scanner, new RangeTransform(this.helper, true));
    }

    private Iterable<ValueRange<T>> reverseScan(ValueRange<T> queryRange, Authorizations auths) throws TableNotFoundException {
        Scanner scanner = this.connector.createScanner(this.tableName, auths);
        scanner.setRange(new Range((CharSequence)("u\u0000" + this.helper.encode((Comparable)queryRange.getStart()) + "\u0000"), (CharSequence)("u\u0000" + this.helper.encode((Comparable)queryRange.getStop()) + "\u0000" + "\uffff")));
        IteratorSetting setting = new IteratorSetting(40, ReverseScanFilter.class);
        ReverseScanFilter.setQueryLowBound(setting, this.helper.encode((Comparable)queryRange.getStart()));
        scanner.addScanIterator(setting);
        return Iterables.transform((Iterable)scanner, new RangeTransform(this.helper, false));
    }

    private Iterable<ValueRange<T>> overlappingScan(ValueRange<T> queryRange, Authorizations auths) throws TableNotFoundException {
        T maxDistance = this.getMaxDistance(auths);
        if (maxDistance == null || this.helper.distance(queryRange).compareTo(maxDistance) >= 0) {
            return Iterables2.emptyIterable();
        }
        Scanner scanner = this.connector.createScanner(this.tableName, auths);
        scanner.setRange(new Range((CharSequence)("l\u0000" + this.helper.encode(this.helper.distance(new ValueRange(maxDistance, queryRange.getStop()))) + "\u0000"), true, (CharSequence)("l\u0000" + this.helper.encode((Comparable)queryRange.getStart()) + "\u0000"), false));
        IteratorSetting setting = new IteratorSetting(40, OverlappingScanFilter.class);
        OverlappingScanFilter.setQueryUpperBound(setting, this.helper.encode((Comparable)queryRange.getStop()));
        scanner.addScanIterator(setting);
        return Iterables.transform((Iterable)scanner, new RangeTransform(this.helper, true));
    }

    @Override
    public Iterable<ValueRange<T>> query(ValueRange<T> range, Auths auths) {
        Preconditions.checkNotNull(range);
        Preconditions.checkNotNull((Object)auths);
        Preconditions.checkState((boolean)this.helper.isValid(range), (Object)"Invalid range.");
        Authorizations authorizations = auths.getAuths();
        try {
            return Iterables.concat(this.forwardScan(range, authorizations), this.reverseScan(range, authorizations), this.overlappingScan(range, authorizations));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class RangeTransform<T extends Comparable<T>>
    implements Function<Map.Entry<Key, Value>, ValueRange<T>> {
        private final RangeHelper<T> helper;
        private final int lowIdx;
        private final int highIdx;

        private RangeTransform(RangeHelper<T> helper, boolean lowFirst) {
            this.helper = helper;
            this.lowIdx = lowFirst ? 1 : 2;
            this.highIdx = lowFirst ? 2 : 1;
        }

        public ValueRange<T> apply(Map.Entry<Key, Value> entry) {
            String[] vals = StringUtils.splitPreserveAllTokens((String)entry.getKey().getRow().toString(), (String)"\u0000");
            T lower = this.helper.decode(vals[this.lowIdx]);
            T upper = this.helper.decode(vals[this.highIdx]);
            return new ValueRange(lower, upper);
        }
    }
}

