/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.rangestore.iterator;

import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Filter;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.commons.lang.StringUtils;

public class OverlappingScanFilter
extends Filter {
    private static final String UPPER_BOUND_OPTION = "upperbound";
    private String queryUpperBound = "";

    public static void setQueryUpperBound(IteratorSetting iterConfig, String queryLowBound) {
        iterConfig.addOption(UPPER_BOUND_OPTION, queryLowBound);
    }

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        if (options.containsKey(UPPER_BOUND_OPTION)) {
            this.queryUpperBound = options.get(UPPER_BOUND_OPTION);
        }
    }

    public boolean accept(Key key, Value value) {
        String[] vals = StringUtils.splitPreserveAllTokens((String)key.getRow().toString(), (String)"\u0000");
        return vals.length == 3 && vals[2].compareTo(this.queryUpperBound) > 0;
    }
}

