/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.rangestore.helper;

import org.calrissian.accumulorecipes.rangestore.helper.RangeHelper;
import org.calrissian.mango.domain.ValueRange;
import org.calrissian.mango.types.LexiTypeEncoders;
import org.calrissian.mango.types.TypeEncoder;

public class LongRangeHelper
implements RangeHelper<Long> {
    private static final TypeEncoder<Long, String> encoder = LexiTypeEncoders.longEncoder();

    @Override
    public boolean isValid(ValueRange<Long> range) {
        return (Long)range.getStop() >= (Long)range.getStart();
    }

    @Override
    public Long distance(ValueRange<Long> range) {
        return (Long)range.getStop() - (Long)range.getStart();
    }

    @Override
    public String encode(Long value) {
        return (String)encoder.encode((Object)value);
    }

    @Override
    public String encodeComplement(Long value) {
        return this.encode(value ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public Long decode(String value) {
        return (Long)encoder.decode((Object)value);
    }

    @Override
    public Long decodeComplement(String value) {
        return this.decode(value) ^ 0xFFFFFFFFFFFFFFFFL;
    }
}

