/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.rangestore.iterator;

import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Filter;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.commons.lang.StringUtils;

public class ReverseScanFilter
extends Filter {
    private static final String LOW_BOUND_OPTION = "lowbound";
    private String queryLowBound = "";

    public static void setQueryLowBound(IteratorSetting iterConfig, String queryLowBound) {
        iterConfig.addOption(LOW_BOUND_OPTION, queryLowBound);
    }

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        if (options.containsKey(LOW_BOUND_OPTION)) {
            this.queryLowBound = options.get(LOW_BOUND_OPTION);
        }
    }

    public boolean accept(Key key, Value value) {
        String[] vals = StringUtils.splitPreserveAllTokens((String)key.getRow().toString(), (String)"\u0000");
        return vals.length == 3 && vals[2].compareTo(this.queryLowBound) < 0;
    }
}

