/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.test;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.calrissian.mango.domain.Pair;

public class MockRecordReader<K, V>
extends RecordReader<K, V> {
    Iterator<Pair<K, V>> itrPairs;
    Pair<K, V> curPair;

    public MockRecordReader(Iterable<Pair<K, V>> pairs) {
        Preconditions.checkNotNull(pairs);
        this.itrPairs = pairs.iterator();
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.itrPairs.hasNext()) {
            this.curPair = this.itrPairs.next();
            return true;
        }
        return false;
    }

    public K getCurrentKey() throws IOException, InterruptedException {
        return (K)this.curPair.getOne();
    }

    public V getCurrentValue() throws IOException, InterruptedException {
        return (V)this.curPair.getTwo();
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.itrPairs.hasNext() ? 0.0f : 1.0f;
    }

    public void close() throws IOException {
    }
}

