/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.accumulo.pool;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.io.Text;
import org.calrissian.mango.accumulo.pool.ThreadPoolConnector;
import org.calrissian.mango.accumulo.pool.ThreadedResource;

public class BatchScannerThreadedResource
implements BatchScanner,
ThreadedResource {
    private final BatchScanner batchScanner;
    private final ThreadPoolConnector threadPoolConnector;
    private final int numThreads;

    public BatchScannerThreadedResource(BatchScanner batchScanner, ThreadPoolConnector threadPoolConnector, int numThreads) {
        this.batchScanner = batchScanner;
        this.threadPoolConnector = threadPoolConnector;
        this.numThreads = numThreads;
    }

    public void setRanges(Collection<Range> ranges) {
        this.batchScanner.setRanges(ranges);
    }

    public void close() {
        this.batchScanner.close();
        this.threadPoolConnector.releaseResources(this);
    }

    public void addScanIterator(IteratorSetting cfg) {
        this.batchScanner.addScanIterator(cfg);
    }

    public void removeScanIterator(String iteratorName) {
        this.batchScanner.removeScanIterator(iteratorName);
    }

    public void updateScanIteratorOption(String iteratorName, String key, String value) {
        this.batchScanner.updateScanIteratorOption(iteratorName, key, value);
    }

    public void setScanIterators(int priority, String iteratorClass, String iteratorName) throws IOException {
        this.batchScanner.setScanIterators(priority, iteratorClass, iteratorName);
    }

    public void setScanIteratorOption(String iteratorName, String key, String value) {
        this.batchScanner.setScanIteratorOption(iteratorName, key, value);
    }

    public void setupRegex(String iteratorName, int iteratorPriority) throws IOException {
        this.batchScanner.setupRegex(iteratorName, iteratorPriority);
    }

    public void setRowRegex(String regex) {
        this.batchScanner.setRowRegex(regex);
    }

    public void setColumnFamilyRegex(String regex) {
        this.batchScanner.setColumnFamilyRegex(regex);
    }

    public void setColumnQualifierRegex(String regex) {
        this.batchScanner.setColumnQualifierRegex(regex);
    }

    public void setValueRegex(String regex) {
        this.batchScanner.setValueRegex(regex);
    }

    public void fetchColumnFamily(Text col) {
        this.batchScanner.fetchColumnFamily(col);
    }

    public void fetchColumn(Text colFam, Text colQual) {
        this.batchScanner.fetchColumn(colFam, colQual);
    }

    public void clearColumns() {
        this.batchScanner.clearColumns();
    }

    public void clearScanIterators() {
        this.batchScanner.clearScanIterators();
    }

    public Iterator<Map.Entry<Key, Value>> iterator() {
        return this.batchScanner.iterator();
    }

    @Override
    public int getNumThreads() {
        return this.numThreads;
    }
}

