/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.accumulo.pool;

import com.google.common.base.Preconditions;
import org.apache.accumulo.core.client.BatchDeleter;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.core.client.admin.SecurityOperations;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.security.Authorizations;
import org.calrissian.mango.accumulo.pool.BatchScannerThreadedResource;
import org.calrissian.mango.accumulo.pool.ThreadedResource;
import org.calrissian.mango.accumulo.util.BatchScannerWithScanners;

public class ThreadPoolConnector
extends Connector {
    private final Connector wrapped;
    private final int maxThreads;
    private int usedThreads = 0;
    private final Object lock = new Object();

    public ThreadPoolConnector(Connector wrapped, int maxThreads) {
        Preconditions.checkArgument((maxThreads > 0 ? 1 : 0) != 0);
        this.wrapped = wrapped;
        this.maxThreads = maxThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int allocateNumThreads(int numQueryThreads) {
        Preconditions.checkArgument((numQueryThreads > 0 ? 1 : 0) != 0, (Object)"Number of query threads must be greater than 0");
        Object object = this.lock;
        synchronized (object) {
            int availableThreads = this.maxThreads - this.usedThreads;
            if (availableThreads == 0) {
                return 0;
            }
            if (numQueryThreads > availableThreads) {
                this.usedThreads = this.maxThreads;
                return availableThreads;
            }
            this.usedThreads += numQueryThreads;
            return numQueryThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseResources(ThreadedResource tr) {
        Preconditions.checkNotNull((Object)tr);
        int numThreads = tr.getNumThreads();
        Preconditions.checkArgument((numThreads > 0 ? 1 : 0) != 0);
        Object object = this.lock;
        synchronized (object) {
            int newPoolSize = this.usedThreads - numThreads;
            if (newPoolSize < 0) {
                newPoolSize = 0;
            }
            this.usedThreads = newPoolSize;
        }
    }

    public BatchScanner createBatchScanner(String tableName, Authorizations authorizations, int numQueryThreads) throws TableNotFoundException {
        if ((numQueryThreads = this.allocateNumThreads(numQueryThreads)) > 0) {
            return new BatchScannerThreadedResource(this.wrapped.createBatchScanner(tableName, authorizations, numQueryThreads), this, numQueryThreads);
        }
        return new BatchScannerWithScanners(this, tableName, authorizations);
    }

    public BatchDeleter createBatchDeleter(String tableName, Authorizations authorizations, int numQueryThreads, long maxMemory, long maxLatency, int maxWriteThreads) throws TableNotFoundException {
        return this.wrapped.createBatchDeleter(tableName, authorizations, numQueryThreads, maxMemory, maxLatency, maxWriteThreads);
    }

    public BatchWriter createBatchWriter(String tableName, long maxMemory, long maxLatency, int maxWriteThreads) throws TableNotFoundException {
        return this.wrapped.createBatchWriter(tableName, maxMemory, maxLatency, maxWriteThreads);
    }

    public MultiTableBatchWriter createMultiTableBatchWriter(long maxMemory, long maxLatency, int maxWriteThreads) {
        return this.wrapped.createMultiTableBatchWriter(maxMemory, maxLatency, maxWriteThreads);
    }

    public Scanner createScanner(String tableName, Authorizations authorizations) throws TableNotFoundException {
        return this.wrapped.createScanner(tableName, authorizations);
    }

    public Instance getInstance() {
        return this.wrapped.getInstance();
    }

    public String whoami() {
        return this.wrapped.whoami();
    }

    public synchronized TableOperations tableOperations() {
        return this.wrapped.tableOperations();
    }

    public synchronized SecurityOperations securityOperations() {
        return this.wrapped.securityOperations();
    }

    public synchronized InstanceOperations instanceOperations() {
        return this.wrapped.instanceOperations();
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public int getUsedThreads() {
        return this.usedThreads;
    }

    public int getNumAvailable() {
        return this.maxThreads - this.usedThreads;
    }
}

