/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.accumulo.types;

import java.net.URI;
import java.util.Date;
import org.calrissian.mango.accumulo.types.impl.BooleanEncoder;
import org.calrissian.mango.accumulo.types.impl.BooleanReverseEncoder;
import org.calrissian.mango.accumulo.types.impl.ByteEncoder;
import org.calrissian.mango.accumulo.types.impl.ByteReverseEncoder;
import org.calrissian.mango.accumulo.types.impl.DateEncoder;
import org.calrissian.mango.accumulo.types.impl.DateReverseEncoder;
import org.calrissian.mango.accumulo.types.impl.DoubleEncoder;
import org.calrissian.mango.accumulo.types.impl.DoubleReverseEncoder;
import org.calrissian.mango.accumulo.types.impl.FloatEncoder;
import org.calrissian.mango.accumulo.types.impl.FloatReverseEncoder;
import org.calrissian.mango.accumulo.types.impl.IPv4Encoder;
import org.calrissian.mango.accumulo.types.impl.IPv4ReverseEncoder;
import org.calrissian.mango.accumulo.types.impl.IntegerEncoder;
import org.calrissian.mango.accumulo.types.impl.IntegerReverseEncoder;
import org.calrissian.mango.accumulo.types.impl.LongEncoder;
import org.calrissian.mango.accumulo.types.impl.LongReverseEncoder;
import org.calrissian.mango.accumulo.types.impl.ReverseEncoder;
import org.calrissian.mango.domain.IPv4;
import org.calrissian.mango.types.GenericTypeEncoders;
import org.calrissian.mango.types.TypeEncoder;
import org.calrissian.mango.types.TypeRegistry;

public class AccumuloTypeEncoders {
    public static final TypeRegistry<String> ACCUMULO_TYPES = new TypeRegistry(new TypeEncoder[]{AccumuloTypeEncoders.booleanEncoder(), AccumuloTypeEncoders.byteEncoder(), AccumuloTypeEncoders.dateEncoder(), AccumuloTypeEncoders.doubleEncoder(), AccumuloTypeEncoders.floatEncoder(), AccumuloTypeEncoders.integerEncoder(), AccumuloTypeEncoders.ipv4Encoder(), AccumuloTypeEncoders.longEncoder(), AccumuloTypeEncoders.stringEncoder(), AccumuloTypeEncoders.uriEncoder()});
    public static final TypeRegistry<String> ACCUMULO_REVERSE_TYPES = new TypeRegistry(new TypeEncoder[]{AccumuloTypeEncoders.booleanRevEncoder(), AccumuloTypeEncoders.byteRevEncoder(), AccumuloTypeEncoders.dateRevEncoder(), AccumuloTypeEncoders.doubleRevEncoder(), AccumuloTypeEncoders.floatRevEncoder(), AccumuloTypeEncoders.integerRevEncoder(), AccumuloTypeEncoders.ipv4RevEncoder(), AccumuloTypeEncoders.longRevEncoder(), AccumuloTypeEncoders.stringRevEncoder(), AccumuloTypeEncoders.uriRevEncoder()});

    public static <T> TypeEncoder<T, String> reverseEncoder(TypeEncoder<T, String> sourceEncoder) {
        return new ReverseEncoder<T>(sourceEncoder);
    }

    public static TypeEncoder<Boolean, String> booleanEncoder() {
        return new BooleanEncoder();
    }

    public static TypeEncoder<Boolean, String> booleanRevEncoder() {
        return new BooleanReverseEncoder();
    }

    public static TypeEncoder<Byte, String> byteEncoder() {
        return new ByteEncoder();
    }

    public static TypeEncoder<Byte, String> byteRevEncoder() {
        return new ByteReverseEncoder();
    }

    public static TypeEncoder<Date, String> dateEncoder() {
        return new DateEncoder();
    }

    public static TypeEncoder<Date, String> dateRevEncoder() {
        return new DateReverseEncoder();
    }

    public static TypeEncoder<Double, String> doubleEncoder() {
        return new DoubleEncoder();
    }

    public static TypeEncoder<Double, String> doubleRevEncoder() {
        return new DoubleReverseEncoder();
    }

    public static TypeEncoder<Float, String> floatEncoder() {
        return new FloatEncoder();
    }

    public static TypeEncoder<Float, String> floatRevEncoder() {
        return new FloatReverseEncoder();
    }

    public static TypeEncoder<Integer, String> integerEncoder() {
        return new IntegerEncoder();
    }

    public static TypeEncoder<Integer, String> integerRevEncoder() {
        return new IntegerReverseEncoder();
    }

    public static TypeEncoder<IPv4, String> ipv4Encoder() {
        return new IPv4Encoder();
    }

    public static TypeEncoder<IPv4, String> ipv4RevEncoder() {
        return new IPv4ReverseEncoder();
    }

    public static TypeEncoder<Long, String> longEncoder() {
        return new LongEncoder();
    }

    public static TypeEncoder<Long, String> longRevEncoder() {
        return new LongReverseEncoder();
    }

    public static TypeEncoder<String, String> stringEncoder() {
        return GenericTypeEncoders.stringEncoder();
    }

    public static TypeEncoder<String, String> stringRevEncoder() {
        return AccumuloTypeEncoders.reverseEncoder(AccumuloTypeEncoders.stringEncoder());
    }

    public static TypeEncoder<URI, String> uriEncoder() {
        return GenericTypeEncoders.uriEncoder();
    }

    public static TypeEncoder<URI, String> uriRevEncoder() {
        return AccumuloTypeEncoders.reverseEncoder(AccumuloTypeEncoders.uriEncoder());
    }
}

