/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.accumulo.types.impl;

import com.google.common.base.Preconditions;
import org.calrissian.mango.accumulo.types.impl.EncodingUtils;
import org.calrissian.mango.types.TypeEncoder;
import org.calrissian.mango.types.exception.TypeDecodingException;
import org.calrissian.mango.types.exception.TypeEncodingException;

public class ReverseEncoder<T>
implements TypeEncoder<T, String> {
    private final TypeEncoder<T, String> encoder;

    public ReverseEncoder(TypeEncoder<T, String> encoder) {
        this.encoder = encoder;
    }

    public String getAlias() {
        return this.encoder.getAlias();
    }

    public Class<T> resolves() {
        return this.encoder.resolves();
    }

    public String encode(T value) throws TypeEncodingException {
        String encoded = (String)this.encoder.encode(value);
        return new String(EncodingUtils.reverse(encoded.getBytes()));
    }

    public T decode(String value) throws TypeDecodingException {
        Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
        String reversed = new String(EncodingUtils.reverse(value.getBytes()));
        return (T)this.encoder.decode((Object)reversed);
    }
}

