/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.accumulo.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.ScannerOptions;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.thrift.IterInfo;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.hadoop.io.Text;

public class BatchScannerWithScanners
extends ScannerOptions
implements BatchScanner {
    private final Connector connector;
    private final String tableName;
    private final Authorizations authorizations;
    private Collection<Range> ranges;

    public BatchScannerWithScanners(Connector connector, String tableName, Authorizations authorizations) {
        this.connector = connector;
        this.tableName = tableName;
        this.authorizations = authorizations;
    }

    public void setRanges(Collection<Range> ranges) {
        Preconditions.checkNotNull(ranges);
        this.ranges = Collections.unmodifiableCollection(ranges);
    }

    public void close() {
    }

    public Iterator<Map.Entry<Key, Value>> iterator() {
        return Iterables.concat((Iterable)Iterables.transform(this.ranges, (Function)new Function<Range, Iterable<Map.Entry<Key, Value>>>(){

            public Iterable<Map.Entry<Key, Value>> apply(Range range) {
                try {
                    Scanner scanner = BatchScannerWithScanners.this.connector.createScanner(BatchScannerWithScanners.this.tableName, BatchScannerWithScanners.this.authorizations);
                    scanner.setRange(range);
                    for (IterInfo iterInfo : BatchScannerWithScanners.this.serverSideIteratorList) {
                        String iterName = iterInfo.getIterName();
                        IteratorSetting iteratorSetting = new IteratorSetting(iterInfo.getPriority(), iterName, iterInfo.getClassName());
                        iteratorSetting.addOptions((Map)BatchScannerWithScanners.this.serverSideIteratorOptions.get(iterName));
                        scanner.addScanIterator(iteratorSetting);
                    }
                    for (Column column : BatchScannerWithScanners.this.fetchedColumns) {
                        scanner.fetchColumn(new Text(column.getColumnFamily()), new Text(column.getColumnQualifier()));
                    }
                    return scanner;
                }
                catch (TableNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        })).iterator();
    }
}

