/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.collect;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Iterator;
import java.util.Queue;
import org.calrissian.mango.collect.Iterators2;

public class Iterables2 {
    public static <T> Iterable<T> simpleIterable(final Iterable<T> iterable) {
        Preconditions.checkNotNull(iterable);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return iterable.iterator();
            }
        };
    }

    public static <T> Iterable<T> emptyIterable() {
        return Collections.emptyList();
    }

    public static <T> Iterable<T> singletonIterable(T data) {
        return Collections.singleton(data);
    }

    public static <T> Iterable<T> distinct(final Iterable<T> iterable) {
        Preconditions.checkNotNull(iterable);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators2.distinct(iterable.iterator());
            }
        };
    }

    public static <T> Iterable<T> drainingIterable(Queue<T> queue) {
        final Iterator<T> iterator = Iterators2.drainingIterator(queue);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return iterator;
            }
        };
    }
}

