/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.types;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import org.calrissian.mango.domain.IPv4;
import org.calrissian.mango.types.TypeEncoder;
import org.calrissian.mango.types.TypeRegistry;
import org.calrissian.mango.types.encoders.AbstractBooleanEncoder;
import org.calrissian.mango.types.encoders.AbstractByteEncoder;
import org.calrissian.mango.types.encoders.AbstractDateEncoder;
import org.calrissian.mango.types.encoders.AbstractDoubleEncoder;
import org.calrissian.mango.types.encoders.AbstractFloatEncoder;
import org.calrissian.mango.types.encoders.AbstractIPv4Encoder;
import org.calrissian.mango.types.encoders.AbstractIntegerEncoder;
import org.calrissian.mango.types.encoders.AbstractLongEncoder;
import org.calrissian.mango.types.encoders.AbstractStringEncoder;
import org.calrissian.mango.types.encoders.AbstractURIEncoder;
import org.calrissian.mango.types.exception.TypeDecodingException;

public class GenericTypeEncoders {
    public static final TypeRegistry<String> DEFAULT_TYPES = new TypeRegistry(GenericTypeEncoders.booleanEncoder(), GenericTypeEncoders.byteEncoder(), GenericTypeEncoders.dateEncoder(), GenericTypeEncoders.doubleEncoder(), GenericTypeEncoders.floatEncoder(), GenericTypeEncoders.integerEncoder(), GenericTypeEncoders.ipv4Encoder(), GenericTypeEncoders.longEncoder(), GenericTypeEncoders.stringEncoder(), GenericTypeEncoders.uriEncoder());

    public static TypeEncoder<Boolean, String> booleanEncoder() {
        return new AbstractBooleanEncoder<String>(){

            @Override
            public String encode(Boolean value) {
                Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
                return value.toString();
            }

            @Override
            public Boolean decode(String value) {
                Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
                String lowercase = value.toLowerCase();
                if (!lowercase.equals("true") && !lowercase.equals("false")) {
                    throw new RuntimeException("The value " + value + " is not a valid boolean.");
                }
                return Boolean.parseBoolean(lowercase);
            }
        };
    }

    public static TypeEncoder<Byte, String> byteEncoder() {
        return new AbstractByteEncoder<String>(){

            @Override
            public String encode(Byte value) {
                Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
                return value.toString();
            }

            @Override
            public Byte decode(String value) {
                Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
                return Byte.parseByte(value);
            }
        };
    }

    public static TypeEncoder<Date, String> dateEncoder() {
        return new AbstractDateEncoder<String>(){

            @Override
            public String encode(Date value) {
                Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
                return Long.toString(value.getTime());
            }

            @Override
            public Date decode(String value) {
                Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
                return new Date(Long.parseLong(value));
            }
        };
    }

    public static TypeEncoder<Double, String> doubleEncoder() {
        return new AbstractDoubleEncoder<String>(){

            @Override
            public String encode(Double value) {
                Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
                return value.toString();
            }

            @Override
            public Double decode(String value) {
                Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
                return Double.parseDouble(value);
            }
        };
    }

    public static TypeEncoder<Float, String> floatEncoder() {
        return new AbstractFloatEncoder<String>(){

            @Override
            public String encode(Float value) {
                Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
                return value.toString();
            }

            @Override
            public Float decode(String value) {
                Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
                return Float.valueOf(Float.parseFloat(value));
            }
        };
    }

    public static TypeEncoder<Integer, String> integerEncoder() {
        return new AbstractIntegerEncoder<String>(){

            @Override
            public String encode(Integer value) {
                Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
                return value.toString();
            }

            @Override
            public Integer decode(String value) {
                Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
                return Integer.parseInt(value);
            }
        };
    }

    public static TypeEncoder<IPv4, String> ipv4Encoder() {
        return new AbstractIPv4Encoder<String>(){

            @Override
            public String encode(IPv4 value) {
                Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
                return value.toString();
            }

            @Override
            public IPv4 decode(String value) {
                Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
                return new IPv4(value);
            }
        };
    }

    public static TypeEncoder<Long, String> longEncoder() {
        return new AbstractLongEncoder<String>(){

            @Override
            public String encode(Long value) {
                Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
                return value.toString();
            }

            @Override
            public Long decode(String value) {
                Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
                return Long.parseLong(value);
            }
        };
    }

    public static TypeEncoder<String, String> stringEncoder() {
        return new AbstractStringEncoder<String>(){

            @Override
            public String encode(String value) {
                Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
                return value;
            }

            @Override
            public String decode(String value) {
                Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
                return value;
            }
        };
    }

    public static TypeEncoder<URI, String> uriEncoder() {
        return new AbstractURIEncoder<String>(){

            @Override
            public String encode(URI value) {
                Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
                return value.toString();
            }

            @Override
            public URI decode(String value) throws TypeDecodingException {
                Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
                try {
                    return new URI(value);
                }
                catch (URISyntaxException e) {
                    throw new TypeDecodingException(e);
                }
            }
        };
    }
}

