/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.domain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.calrissian.mango.domain.Tuple;
import org.calrissian.mango.domain.TupleStore;

public class BaseTupleStore
implements TupleStore {
    private Map<String, Set<Tuple>> tuples = new HashMap<String, Set<Tuple>>();

    @Override
    public void put(Tuple tuple) {
        Set<Tuple> keyedTuples = this.tuples.get(tuple.getKey());
        if (keyedTuples == null) {
            keyedTuples = new HashSet<Tuple>();
            this.tuples.put(tuple.getKey(), keyedTuples);
        }
        keyedTuples.add(tuple);
    }

    @Override
    public void putAll(Iterable<Tuple> tuples) {
        for (Tuple tuple : tuples) {
            this.put(tuple);
        }
    }

    @Override
    public Collection<Tuple> getTuples() {
        return ImmutableList.copyOf((Iterable)Iterables.concat(this.tuples.values()));
    }

    @Override
    public Collection<Tuple> getAll(String key) {
        return this.tuples.get(key);
    }

    @Override
    public <T> Tuple<T> get(String key) {
        return this.tuples.get(key) != null ? this.tuples.get(key).iterator().next() : null;
    }

    @Override
    public Set<String> keys() {
        return this.tuples.keySet();
    }

    @Override
    public <T> Tuple<T> remove(Tuple<T> t) {
        Set<Tuple> tupelSet;
        if (this.tuples.containsKey(t.getKey()) && (tupelSet = this.tuples.get(t.getKey())).remove(t)) {
            return t;
        }
        return null;
    }

    @Override
    public <T> Tuple<T> remove(String key) {
        if (this.tuples.containsKey(key)) {
            Tuple t;
            Set<Tuple> tupleSet = this.tuples.get(key);
            Tuple tuple = t = tupleSet.size() > 0 ? tupleSet.iterator().next() : null;
            if (t != null && this.tuples.get(key).remove(t)) {
                return t;
            }
        }
        return null;
    }

    @Override
    public Collection<Tuple> removeAll(String key) {
        return this.tuples.remove(key);
    }

    @Override
    public Collection<Tuple> removeAll(Collection<Tuple> tuples) {
        LinkedList<Tuple> removedTuples = new LinkedList<Tuple>();
        for (Tuple tuple : tuples) {
            removedTuples.add(this.remove(tuple));
        }
        return removedTuples;
    }

    public int hashCode() {
        return this.tuples != null ? this.tuples.hashCode() : 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseTupleStore that = (BaseTupleStore)o;
        return !(this.tuples != null ? !this.tuples.equals(that.tuples) : that.tuples != null);
    }
}

