/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.domain.entity;

import com.google.common.base.Preconditions;
import java.util.UUID;
import org.calrissian.mango.domain.BaseTupleStore;
import org.calrissian.mango.domain.entity.Entity;

public class BaseEntity
extends BaseTupleStore
implements Entity {
    private String id;
    private String type;

    public BaseEntity(String type) {
        this(type, UUID.randomUUID().toString());
    }

    public BaseEntity(String type, String id) {
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull((Object)id);
        this.id = id;
        this.type = type;
    }

    public BaseEntity(Entity entity) {
        this(entity.getType(), entity.getId());
        this.getTuples().addAll(entity.getTuples());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public String toString() {
        return "BaseEntity{id='" + this.id + '\'' + ", type='" + this.type + '\'' + ", tuples='" + this.getTuples() + '\'' + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseEntity that = (BaseEntity)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }
}

