/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.domain.event;

import java.util.UUID;
import org.calrissian.mango.domain.BaseTupleStore;
import org.calrissian.mango.domain.event.Event;

public class BaseEvent
extends BaseTupleStore
implements Event {
    protected final String id;
    protected final long timestamp;

    public BaseEvent() {
        this(UUID.randomUUID().toString());
    }

    public BaseEvent(String id) {
        this(id, System.currentTimeMillis());
    }

    public BaseEvent(String id, long timestamp) {
        this.id = id;
        this.timestamp = timestamp;
    }

    public BaseEvent(Event event) {
        this(event.getId(), event.getTimestamp());
        this.getTuples().addAll(event.getTuples());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseEvent baseEvent = (BaseEvent)o;
        if (this.timestamp != baseEvent.timestamp) {
            return false;
        }
        return !(this.id != null ? !this.id.equals(baseEvent.id) : baseEvent.id != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    public String toString() {
        return "BaseEvent{id='" + this.id + '\'' + ", timestamp=" + this.timestamp + ", tuples=" + this.getTuples() + '}';
    }
}

