/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.types;

import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.calrissian.mango.types.TypeEncoder;
import org.calrissian.mango.types.exception.TypeDecodingException;
import org.calrissian.mango.types.exception.TypeEncodingException;

public class TypeRegistry<U>
implements Serializable {
    private final Map<String, TypeEncoder<?, U>> aliasMapping = new LinkedHashMap();
    private final Map<Class<?>, TypeEncoder<?, U>> classMapping = new LinkedHashMap();

    public TypeRegistry(TypeEncoder<?, U> ... normalizers) {
        this(Arrays.asList(normalizers));
    }

    public TypeRegistry(TypeRegistry<U> registry, TypeEncoder<?, U> ... normalizers) {
        this(Iterables.concat(Arrays.asList(normalizers), registry.getAllEncoders()));
    }

    public TypeRegistry(Iterable<TypeEncoder<?, U>> normalizers) {
        for (TypeEncoder<?, U> resolver : normalizers) {
            if (this.aliasMapping.containsKey(resolver.getAlias())) {
                throw new IllegalArgumentException("The aliases provided by the normalizers must be unique");
            }
            if (this.classMapping.containsKey(resolver.resolves())) {
                throw new IllegalArgumentException("There can only be one normalizer per class type.");
            }
            this.aliasMapping.put(resolver.getAlias(), resolver);
            this.classMapping.put(resolver.resolves(), resolver);
        }
    }

    public String getAlias(Object obj) {
        if (obj == null) {
            return null;
        }
        TypeEncoder<?, U> encoder = this.classMapping.get(obj.getClass());
        if (encoder != null) {
            return encoder.getAlias();
        }
        return null;
    }

    public U encode(Object value) {
        TypeEncoder<?, U> encoder = this.classMapping.get(value.getClass());
        if (encoder != null) {
            return encoder.encode(value);
        }
        throw new TypeEncodingException("An unknown type [" + value.getClass() + "] was encountered");
    }

    public Object decode(String alias, U value) {
        TypeEncoder<?, U> encoder = this.aliasMapping.get(alias);
        if (encoder != null) {
            return encoder.decode(value);
        }
        throw new TypeDecodingException("An unknown type [" + value + "] was encountered");
    }

    public Collection<TypeEncoder<?, U>> getAllEncoders() {
        return Collections.unmodifiableCollection(this.classMapping.values());
    }
}

