/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.types.encoders.lexi;

class EncodingUtils {
    EncodingUtils() {
    }

    protected static long fromHex(String hex) {
        long value = 0L;
        for (int i = 0; i < hex.length(); ++i) {
            value = value << 4 | (long)Character.digit(hex.charAt(i), 16);
        }
        return value;
    }

    protected static String encodeULong(long value) {
        return String.format("%016x", value);
    }

    protected static String encodeUInt(int value) {
        return String.format("%08x", value);
    }

    protected static int normalizeFloat(float value) {
        if (value > 0.0f) {
            return Float.floatToIntBits(value) ^ Integer.MIN_VALUE;
        }
        return ~Float.floatToIntBits(value);
    }

    protected static float denormalizeFloat(int value) {
        if (value > 0) {
            return Float.intBitsToFloat(~value);
        }
        return Float.intBitsToFloat(value ^ Integer.MIN_VALUE);
    }

    protected static long normalizeDouble(double value) {
        if (value > 0.0) {
            return Double.doubleToRawLongBits(value) ^ Long.MIN_VALUE;
        }
        return Double.doubleToRawLongBits(value) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    protected static double denormalizeDouble(long value) {
        if (value > 0L) {
            return Double.longBitsToDouble(value ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return Double.longBitsToDouble(value ^ Long.MIN_VALUE);
    }
}

