/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.collect;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;

public class Iterators2 {
    private Iterators2() {
    }

    public static <T> Iterator<T> distinct(final Iterator<T> iterator) {
        Preconditions.checkNotNull(iterator);
        return new AbstractIterator<T>(){
            private final PeekingIterator<T> peekingIterator;
            private T curr;
            {
                this.peekingIterator = Iterators.peekingIterator((Iterator)iterator);
                this.curr = null;
            }

            protected T computeNext() {
                while (this.peekingIterator.hasNext() && Objects.equal(this.curr, (Object)this.peekingIterator.peek())) {
                    this.peekingIterator.next();
                }
                if (!this.peekingIterator.hasNext()) {
                    return this.endOfData();
                }
                this.curr = this.peekingIterator.next();
                return this.curr;
            }
        };
    }

    public static <T> Iterator<List<T>> groupBy(final Iterator<? extends T> iterator, final Function<? super T, ?> groupingFunction) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkNotNull(groupingFunction);
        return new AbstractIterator<List<T>>(){
            private final PeekingIterator<T> peekingIterator;
            {
                this.peekingIterator = Iterators.peekingIterator((Iterator)iterator);
            }

            protected List<T> computeNext() {
                if (!this.peekingIterator.hasNext()) {
                    return (List)this.endOfData();
                }
                Object key = groupingFunction.apply(this.peekingIterator.peek());
                ArrayList<Object> group = new ArrayList<Object>();
                do {
                    group.add(this.peekingIterator.next());
                } while (this.peekingIterator.hasNext() && Objects.equal((Object)key, (Object)groupingFunction.apply(this.peekingIterator.peek())));
                return Collections.unmodifiableList(group);
            }
        };
    }

    @Deprecated
    public static <T> Iterator<T> drainingIterator(Queue<T> queue) {
        Preconditions.checkNotNull(queue);
        return Iterators.consumingIterator(queue.iterator());
    }
}

