/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.criteria.visitor;

import java.io.IOException;
import java.io.Writer;
import org.calrissian.mango.criteria.domain.EqualsLeaf;
import org.calrissian.mango.criteria.domain.Leaf;
import org.calrissian.mango.criteria.domain.NotEqualsLeaf;
import org.calrissian.mango.criteria.domain.ParentNode;
import org.calrissian.mango.criteria.domain.RangeLeaf;
import org.calrissian.mango.criteria.visitor.NodeVisitor;

public class PrintNodeVisitor
implements NodeVisitor {
    private Writer writer;

    public PrintNodeVisitor(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void begin(ParentNode node) {
        this.write(node.getClass().getSimpleName() + "(");
    }

    @Override
    public void end(ParentNode node) {
        this.write("),");
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void visit(Leaf node) {
        if (node instanceof NotEqualsLeaf) {
            this.visit((NotEqualsLeaf)node);
        } else if (node instanceof EqualsLeaf) {
            this.visit((EqualsLeaf)node);
        } else if (node instanceof RangeLeaf) {
            this.visit((RangeLeaf)node);
        } else {
            this.write(node.getClass().getSimpleName() + ",");
        }
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void visit(EqualsLeaf equalsLeaf) {
        this.write(String.format("Equals[%s,%s],", equalsLeaf.getKey(), equalsLeaf.getValue().toString()));
    }

    public void visit(NotEqualsLeaf notEqualsLeaf) {
        this.write(String.format("NotEquals[%s,%s],", notEqualsLeaf.getKey(), notEqualsLeaf.getValue().toString()));
    }

    public void visit(RangeLeaf range) {
        this.write(String.format("Range[%s,(%s,%s)],", range.getKey(), range.getStart().toString(), range.getEnd().toString()));
    }

    protected void write(String contents) {
        try {
            this.writer.write(contents);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

