/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.batch;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.calrissian.mango.batch.BatchListener;
import org.calrissian.mango.batch.Batcher;

abstract class AbstractBatcher<T>
implements Batcher<T> {
    private static final Logger logger = Logger.getLogger(AbstractBatcher.class.getName());
    private final ExecutorService batchService;
    private final BatchRunnable batchRunnable;
    private Future<?> batchFuture;
    private final BlockingQueue<T> backingQueue;
    private final BatchListener<T> listener;
    private final ExecutorService handler;
    private volatile boolean isClosed = false;

    AbstractBatcher(BlockingQueue<T> backingQueue, BatchListener<T> listener, ExecutorService handler) {
        this.backingQueue = backingQueue;
        this.listener = listener;
        this.handler = handler;
        this.batchService = Executors.newSingleThreadExecutor();
        this.batchRunnable = new BatchRunnable();
    }

    protected abstract Collection<T> generateBatch(BlockingQueue<T> var1) throws InterruptedException;

    protected AbstractBatcher<T> start() {
        this.batchFuture = this.batchService.submit(this.batchRunnable);
        return this;
    }

    @Override
    public final boolean add(T item) {
        Preconditions.checkNotNull(item);
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (Object)"The batcher has been closed");
        return this.backingQueue.offer(item);
    }

    @Override
    public final boolean add(T item, long timeout, TimeUnit unit) throws InterruptedException {
        Preconditions.checkNotNull(item);
        Preconditions.checkNotNull((Object)((Object)unit));
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (Object)"The batcher has been closed");
        return this.backingQueue.offer(item, timeout, unit);
    }

    @Override
    public final boolean addOrWait(T item) throws InterruptedException {
        Preconditions.checkNotNull(item);
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (Object)"The batcher has been closed");
        this.backingQueue.put(item);
        return true;
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.batchFuture.cancel(true);
        this.batchService.shutdown();
        this.handler.shutdownNow();
    }

    private class BatchRunnable
    implements Runnable {
        private BatchRunnable() {
        }

        @Override
        public void run() {
            block8: while (true) {
                try {
                    while (!(AbstractBatcher.this.isClosed || Thread.interrupted() || AbstractBatcher.this.handler.isShutdown())) {
                        Collection batch;
                        try {
                            batch = AbstractBatcher.this.generateBatch(AbstractBatcher.this.backingQueue);
                        }
                        catch (InterruptedException e) {
                            break block8;
                        }
                        if (batch.isEmpty() || AbstractBatcher.this.handler.isShutdown()) continue;
                        try {
                            AbstractBatcher.this.handler.execute(new Runnable(){

                                @Override
                                public void run() {
                                    AbstractBatcher.this.listener.onBatch(Collections.unmodifiableCollection(batch));
                                }
                            });
                            continue block8;
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Encountered exception sending to batch listener.  Closing the batcher", e);
                            AbstractBatcher.this.close();
                        }
                    }
                    break;
                }
                catch (Throwable e) {
                    try {
                        logger.log(Level.SEVERE, "Batcher should not have throw exception.  Closing the batcher", e);
                        AbstractBatcher.this.close();
                        break;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                        break;
                    }
                }
            }
        }
    }
}

