/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.calrissian.mango.domain.Tuple;
import org.calrissian.mango.domain.TupleStore;

public class BaseTupleStore
implements TupleStore {
    private Multimap<String, Tuple> tuples = ArrayListMultimap.create();

    @Override
    public void put(Tuple tuple) {
        Preconditions.checkNotNull((Object)tuple);
        Preconditions.checkNotNull((Object)tuple.getKey());
        this.tuples.put((Object)tuple.getKey(), (Object)tuple);
    }

    @Override
    public void putAll(Iterable<Tuple> tuples) {
        Preconditions.checkNotNull(tuples);
        for (Tuple tuple : tuples) {
            this.put(tuple);
        }
    }

    @Override
    public Collection<Tuple> getTuples() {
        return Collections.unmodifiableCollection(this.tuples.values());
    }

    @Override
    public Collection<Tuple> getAll(String key) {
        Preconditions.checkNotNull((Object)key);
        return this.tuples.get((Object)key);
    }

    @Override
    public <T> Tuple<T> get(String key) {
        return this.tuples.containsKey((Object)key) ? (Tuple)this.tuples.get((Object)key).iterator().next() : null;
    }

    @Override
    public Set<String> keys() {
        return this.tuples.keySet();
    }

    @Override
    public boolean containsKey(String key) {
        return this.tuples.containsKey((Object)key);
    }

    @Override
    public <T> Tuple<T> remove(Tuple<T> t) {
        Collection tupelSet;
        Preconditions.checkNotNull(t);
        Preconditions.checkNotNull((Object)t.getKey());
        if (this.tuples.containsKey((Object)t.getKey()) && (tupelSet = this.tuples.get((Object)t.getKey())).remove(t)) {
            return t;
        }
        return null;
    }

    @Override
    public <T> Tuple<T> remove(String key) {
        Preconditions.checkNotNull((Object)key);
        if (this.tuples.containsKey((Object)key)) {
            Tuple t;
            Collection tupleSet = this.tuples.get((Object)key);
            Tuple tuple = t = tupleSet.size() > 0 ? (Tuple)tupleSet.iterator().next() : null;
            if (t != null && this.tuples.get((Object)key).remove(t)) {
                return t;
            }
        }
        return null;
    }

    @Override
    public Collection<Tuple> removeAll(String key) {
        Preconditions.checkNotNull((Object)key);
        return this.tuples.removeAll((Object)key);
    }

    @Override
    public Collection<Tuple> removeAll(Collection<Tuple> tuples) {
        Preconditions.checkNotNull(tuples);
        ArrayList<Tuple> removedTuples = new ArrayList<Tuple>();
        for (Tuple tuple : tuples) {
            removedTuples.add(this.remove(tuple));
        }
        return removedTuples;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseTupleStore)) {
            return false;
        }
        BaseTupleStore that = (BaseTupleStore)o;
        return this.tuples.equals(that.tuples);
    }

    public int hashCode() {
        return this.tuples.hashCode();
    }

    @Override
    public int size() {
        return this.tuples.size();
    }
}

