/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.domain.ip;

import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import com.google.common.net.InetAddresses;
import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedBytes;
import java.net.Inet4Address;
import org.calrissian.mango.domain.ip.IP;
import org.calrissian.mango.net.MoreInetAddresses;

public class IPv4
extends IP<Inet4Address>
implements Comparable<IPv4> {
    private static final DiscreteDomain<IPv4> DISCRETE_DOMAIN = new DiscreteDomain<IPv4>(){
        private final IPv4 MIN_VALUE = IPv4.fromString("0.0.0.0");
        private final IPv4 MAX_VALUE = IPv4.fromString("255.255.255.255");

        public IPv4 next(IPv4 iPv4) {
            return new IPv4(MoreInetAddresses.increment((Inet4Address)iPv4.getAddress()));
        }

        public IPv4 previous(IPv4 iPv4) {
            return new IPv4(MoreInetAddresses.decrement((Inet4Address)iPv4.getAddress()));
        }

        public long distance(IPv4 start, IPv4 end) {
            return 1.longs().distance((Comparable)Long.valueOf((long)Ints.fromByteArray((byte[])start.toByteArray()) & 0xFFFFFFFFL), (Comparable)Long.valueOf((long)Ints.fromByteArray((byte[])end.toByteArray()) & 0xFFFFFFFFL));
        }

        public IPv4 minValue() {
            return this.MIN_VALUE;
        }

        public IPv4 maxValue() {
            return this.MAX_VALUE;
        }
    };

    public IPv4(Inet4Address address) {
        super(address);
    }

    @Deprecated
    public IPv4(String ip) {
        super(MoreInetAddresses.forIPv4String(ip));
    }

    @Deprecated
    public IPv4(long ip) {
        super(InetAddresses.fromInteger((int)((int)ip)));
    }

    @Deprecated
    public long getValue() {
        return (long)Ints.fromByteArray((byte[])this.toByteArray()) & 0xFFFFFFFFL;
    }

    @Override
    public int compareTo(IPv4 o) {
        if (o == null) {
            return 1;
        }
        return UnsignedBytes.lexicographicalComparator().compare(this.toByteArray(), o.toByteArray());
    }

    public static IPv4 fromString(String addr) {
        return new IPv4(MoreInetAddresses.forIPv4String(addr));
    }

    public static Range<IPv4> cidrRange(String cidr) {
        try {
            MoreInetAddresses.CidrInfo cidrInfo = MoreInetAddresses.parseCIDR(cidr);
            if (cidrInfo.getNetwork() instanceof Inet4Address && cidrInfo.getBroadcast() instanceof Inet4Address) {
                return Range.closed((Comparable)new IPv4((Inet4Address)cidrInfo.getNetwork()), (Comparable)new IPv4((Inet4Address)cidrInfo.getBroadcast()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalArgumentException(String.format("Invalid IPv4 cidr representation %s", cidr));
    }

    public static DiscreteDomain<IPv4> discreteDomain() {
        return DISCRETE_DOMAIN;
    }
}

