/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;

public class Serializables {
    private Serializables() {
    }

    public static byte[] serialize(Serializable serializable) throws IOException {
        return Serializables.serialize(serializable, false);
    }

    public static byte[] serialize(Serializable serializable, boolean compress) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream o = compress ? new ObjectOutputStream(new GZIPOutputStream(baos)) : new ObjectOutputStream(baos);
        o.writeObject(serializable);
        o.flush();
        o.close();
        return baos.toByteArray();
    }

    public static <T extends Serializable> T deserialize(byte[] bytes) throws IOException, ClassNotFoundException {
        return Serializables.deserialize(bytes, false);
    }

    public static <T extends Serializable> T deserialize(byte[] bytes, boolean compressed) throws IOException, ClassNotFoundException {
        InputStream i = new ByteArrayInputStream(bytes);
        if (compressed) {
            i = new GZIPInputStream(i);
        }
        ObjectInputStream ois = new ObjectInputStream(i);
        Serializable retVal = (Serializable)ois.readObject();
        ois.close();
        return (T)retVal;
    }

    public static byte[] toBase64(Serializable serializable) throws IOException {
        return Base64.encodeBase64((byte[])Serializables.serialize(serializable));
    }

    public static <T extends Serializable> T fromBase64(byte[] bytes) throws IOException, ClassNotFoundException {
        return Serializables.deserialize(Base64.decodeBase64((byte[])bytes));
    }
}

