/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.types.encoders.simple;

import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import java.net.Inet4Address;
import java.net.InetAddress;
import org.calrissian.mango.net.MoreInetAddresses;
import org.calrissian.mango.types.encoders.AbstractInet4AddressEncoder;

public class Inet4AddressEncoder
extends AbstractInet4AddressEncoder<String> {
    @Override
    public String encode(Inet4Address value) {
        Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
        return InetAddresses.toAddrString((InetAddress)value);
    }

    @Override
    public Inet4Address decode(String value) {
        Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
        return MoreInetAddresses.forIPv4String(value);
    }
}

