/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.types.encoders.lexi;

import com.google.common.base.Preconditions;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.calrissian.mango.types.encoders.AbstractInet4AddressEncoder;
import org.calrissian.mango.types.exception.TypeDecodingException;

public class Inet4AddressEncoder
extends AbstractInet4AddressEncoder<String> {
    @Override
    public String encode(Inet4Address value) {
        Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
        return Hex.encodeHexString((byte[])value.getAddress());
    }

    @Override
    public Inet4Address decode(String value) {
        Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
        Preconditions.checkArgument((value.length() == 8 ? 1 : 0) != 0, (Object)"The value is not a valid encoding");
        try {
            return (Inet4Address)InetAddress.getByAddress(Hex.decodeHex((char[])value.toCharArray()));
        }
        catch (UnknownHostException | DecoderException e) {
            throw new TypeDecodingException(e);
        }
    }
}

