/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.types.encoders.lexi;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import org.calrissian.mango.types.TypeEncoder;
import org.calrissian.mango.types.encoders.lexi.EncodingUtils;

public class ReverseEncoder<T>
implements TypeEncoder<T, String> {
    private static final long serialVersionUID = 1L;
    private final TypeEncoder<T, String> encoder;

    public ReverseEncoder(TypeEncoder<T, String> encoder) {
        this.encoder = encoder;
    }

    @Override
    public String getAlias() {
        return this.encoder.getAlias();
    }

    @Override
    public Class<T> resolves() {
        return this.encoder.resolves();
    }

    @Override
    public String encode(T value) {
        String encoded = this.encoder.encode(value);
        return new String(EncodingUtils.reverse(encoded.getBytes()), StandardCharsets.ISO_8859_1);
    }

    @Override
    public T decode(String value) {
        Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
        String reversed = new String(EncodingUtils.reverse(value.getBytes(StandardCharsets.ISO_8859_1)));
        return this.encoder.decode(reversed);
    }
}

