/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.types.encoders.simple;

import com.google.common.base.Preconditions;
import org.calrissian.mango.domain.entity.EntityRelationship;
import org.calrissian.mango.types.encoders.AbstractEntityRelationshipEncoder;
import org.calrissian.mango.types.exception.TypeDecodingException;
import org.calrissian.mango.types.exception.TypeEncodingException;

public class EntityRelationshipEncoder
extends AbstractEntityRelationshipEncoder<String> {
    private static final long serialVersionUID = 1L;
    private static final String SCHEME = "entity://";

    @Override
    public String encode(EntityRelationship value) throws TypeEncodingException {
        Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
        return String.format("%s%s#%s", SCHEME, value.getType(), value.getId());
    }

    @Override
    public EntityRelationship decode(String value) throws TypeDecodingException {
        Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
        Preconditions.checkArgument((value.startsWith(SCHEME) && value.contains("#") ? 1 : 0) != 0, (Object)"The value is not a valid encoding");
        String rel = value.substring(SCHEME.length(), value.length());
        int idx = rel.indexOf(35);
        return new EntityRelationship(rel.substring(0, idx), rel.substring(idx + 1));
    }
}

