/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.collect;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.List;
import org.calrissian.mango.collect.Iterators2;

public class Iterables2 {
    private Iterables2() {
    }

    public static <T> Iterable<T> simpleIterable(final Iterable<T> iterable) {
        Preconditions.checkNotNull(iterable);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return iterable.iterator();
            }
        };
    }

    public static <T> Iterable<T> distinct(final Iterable<T> iterable) {
        Preconditions.checkNotNull(iterable);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators2.distinct(iterable.iterator());
            }
        };
    }

    public static <T> Iterable<List<T>> groupBy(final Iterable<? extends T> iterable, final Function<? super T, ?> groupingFunction) {
        Preconditions.checkNotNull(iterable);
        Preconditions.checkNotNull(groupingFunction);
        return new Iterable<List<T>>(){

            @Override
            public Iterator<List<T>> iterator() {
                return Iterators2.groupBy(iterable.iterator(), groupingFunction);
            }
        };
    }
}

