/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.calrissian.mango.domain.Attribute;
import org.calrissian.mango.domain.AttributeStore;

public abstract class AbstractAttributeStore
implements AttributeStore {
    private static final long serialVersionUID = 1L;
    private final ArrayListMultimap<String, Attribute> attributes;

    protected AbstractAttributeStore(Iterable<? extends Attribute> attributes) {
        Preconditions.checkNotNull(attributes);
        this.attributes = ArrayListMultimap.create();
        for (Attribute attribute : attributes) {
            this.attributes.put((Object)attribute.getKey(), (Object)attribute);
        }
    }

    @Override
    public Collection<Attribute> getAttributes() {
        return Collections.unmodifiableCollection(this.attributes.values());
    }

    @Override
    public Collection<Attribute> getAttributes(String key) {
        return Collections.unmodifiableCollection(this.attributes.get((Object)key));
    }

    @Override
    public <T> Attribute<T> get(String key) {
        return (Attribute)Iterables.getFirst(this.getAttributes(key), null);
    }

    @Override
    public Set<String> keys() {
        return Collections.unmodifiableSet(this.attributes.keySet());
    }

    @Override
    public boolean contains(String key) {
        return this.attributes.containsKey((Object)key);
    }

    @Override
    public int size() {
        return this.attributes.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractAttributeStore)) {
            return false;
        }
        AbstractAttributeStore that = (AbstractAttributeStore)o;
        return this.attributes.equals(that.attributes);
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }
}

